#ifndef CRUX_UNIMOD_H
#define CRUX_UNIMOD_H

// This file was automatically generated by bin/unimod_parser.py

#include <algorithm>
#include <limits>
#include <set>
#include <string>
#include <utility>

namespace Unimod {

enum Position { ANYWHERE, ANY_N, ANY_C, PROTEIN_N, PROTEIN_C };

class Modification {
public:
  Modification():
    title_(""), name_(""), monoMass_(std::numeric_limits<double>::quiet_NaN()), avgMass_(std::numeric_limits<double>::quiet_NaN()) {}
  Modification(
    const std::string& title,
    const std::string& name,
    double monoMass,
    double avgMass,
    const std::set< std::pair<char, Position> > specificities = std::set< std::pair<char, Position> >()
  ):
    title_(title), name_(name), monoMass_(monoMass), avgMass_(avgMass), specificities_(specificities) {
  }
  Modification(const Modification& other):
    title_(other.title_), name_(other.name_), monoMass_(other.monoMass_), avgMass_(other.avgMass_), specificities_(other.specificities_) {
  }
  ~Modification() {}
  friend void swap(Modification& x, Modification& y) {
    using std::swap;
    swap(x.title_, y.title_);
    swap(x.name_, y.name_);
    swap(x.monoMass_, y.monoMass_);
    swap(x.avgMass_, y.avgMass_);
  }
  Modification& operator=(Modification rhs) {
    swap(*this, rhs);
    return *this;
  }
  void addSpecificity(char site, Position position) {
    specificities_.insert(std::make_pair(site, position));
  }
  std::string getTitle() const { return title_; }
  std::string getName() const { return name_; }
  double getMonoMass() const { return monoMass_; }
  double getAvgMass() const { return avgMass_; }
  std::set< std::pair<char, Position> > getSpecificities() const { return specificities_; }
private:
  std::string title_;
  std::string name_;
  double monoMass_;
  double avgMass_;
  std::set< std::pair<char, Position> > specificities_;
};

static Modification Get(int unimodId) {
  switch (unimodId) {
    default:
      return Modification();
    case 1: {
      Modification mod("Acetyl", "Acetylation", 42.010565, 42.036700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 2: {
      Modification mod("Amidated", "Amidation", -0.984016, -0.984800);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('c', PROTEIN_C);
      return mod;
    }
    case 3: {
      Modification mod("Biotin", "Biotinylation", 226.077598, 226.295400);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 4: {
      Modification mod("Carbamidomethyl", "Iodoacetamide derivative", 57.021464, 57.051300);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('U', ANYWHERE);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 5: {
      Modification mod("Carbamyl", "Carbamylation", 43.005814, 43.024700);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('M', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 6: {
      Modification mod("Carboxymethyl", "Iodoacetic acid derivative", 58.005479, 58.036100);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('U', ANYWHERE);
      return mod;
    }
    case 7: {
      Modification mod("Deamidated", "Deamidation", 0.984016, 0.984800);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('F', PROTEIN_N);
      return mod;
    }
    case 8: {
      Modification mod("ICAT-G", "Gygi ICAT(TM) d0", 486.251206, 486.625300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 9: {
      Modification mod("ICAT-G:2H(8)", "Gygi ICAT(TM) d8", 494.301420, 494.674600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 10: {
      Modification mod("Met->Hse", "Homoserine", -29.992806, -30.092200);
      mod.addSpecificity('M', ANY_C);
      return mod;
    }
    case 11: {
      Modification mod("Met->Hsl", "Homoserine lactone", -48.003371, -48.107500);
      mod.addSpecificity('M', ANY_C);
      return mod;
    }
    case 12: {
      Modification mod("ICAT-D:2H(8)", "Applied Biosystems original ICAT(TM) d8", 450.275205, 450.622100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 13: {
      Modification mod("ICAT-D", "Applied Biosystems original ICAT(TM) d0", 442.224991, 442.572800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 17: {
      Modification mod("NIPCAM", "N-isopropylcarboxamidomethyl", 99.068414, 99.131100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 20: {
      Modification mod("PEO-Iodoacetyl-LC-Biotin", "Biotinyl-iodoacetamidyl-3,6-dioxaoctanediamine", 414.193691, 414.519600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 21: {
      Modification mod("Phospho", "Phosphorylation", 79.966331, 79.979900);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 2007: {
      Modification mod("Methamidophos-S", "S-methyl amino phosphinate", 108.975121, 109.087300);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 23: {
      Modification mod("Dehydrated", "Dehydration", -18.010565, -18.015300);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', PROTEIN_C);
      mod.addSpecificity('Q', PROTEIN_C);
      mod.addSpecificity('C', ANY_N);
      return mod;
    }
    case 24: {
      Modification mod("Propionamide", "Acrylamide adduct", 71.037114, 71.077900);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 25: {
      Modification mod("Pyridylacetyl", "pyridylacetyl", 119.037114, 119.120700);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 26: {
      Modification mod("Pyro-carbamidomethyl", "S-carbamoylmethylcysteine cyclization (N-terminus)", 39.994915, 40.020800);
      mod.addSpecificity('C', ANY_N);
      return mod;
    }
    case 27: {
      Modification mod("Glu->pyro-Glu", "Pyro-glu from E", -18.010565, -18.015300);
      mod.addSpecificity('E', ANY_N);
      return mod;
    }
    case 28: {
      Modification mod("Gln->pyro-Glu", "Pyro-glu from Q", -17.026549, -17.030500);
      mod.addSpecificity('Q', ANY_N);
      return mod;
    }
    case 29: {
      Modification mod("SMA", "N-Succinimidyl-2-morpholine acetate", 127.063329, 127.141200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 30: {
      Modification mod("Cation:Na", "Sodium adduct", 21.981943, 21.981800);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 31: {
      Modification mod("Pyridylethyl", "S-pyridylethylation", 105.057849, 105.137200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 34: {
      Modification mod("Methyl", "Methylation", 14.015650, 14.026600);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 35: {
      Modification mod("Oxidation", "Oxidation or Hydroxylation", 15.994915, 15.999400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('U', ANYWHERE);
      mod.addSpecificity('G', ANY_C);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('V', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('M', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      mod.addSpecificity('P', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 36: {
      Modification mod("Dimethyl", "di-Methylation", 28.031300, 28.053200);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('P', PROTEIN_N);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 37: {
      Modification mod("Trimethyl", "tri-Methylation", 42.046950, 42.079700);
      mod.addSpecificity('A', PROTEIN_N);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 39: {
      Modification mod("Methylthio", "Beta-methylthiolation", 45.987721, 46.091600);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 40: {
      Modification mod("Sulfo", "O-Sulfonation", 79.956815, 80.063200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 41: {
      Modification mod("Hex", "Hexose", 162.052824, 162.140600);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 42: {
      Modification mod("Lipoyl", "Lipoyl", 188.032956, 188.310300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 43: {
      Modification mod("HexNAc", "N-Acetylhexosamine", 203.079373, 203.192500);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 44: {
      Modification mod("Farnesyl", "Farnesylation", 204.187801, 204.351100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 45: {
      Modification mod("Myristoyl", "Myristoylation", 210.198366, 210.355600);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('G', ANY_N);
      return mod;
    }
    case 46: {
      Modification mod("PyridoxalPhosphate", "Pyridoxal phosphate", 229.014009, 229.126600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 47: {
      Modification mod("Palmitoyl", "Palmitoylation", 238.229666, 238.408800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 48: {
      Modification mod("GeranylGeranyl", "Geranyl-geranyl", 272.250401, 272.468100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 49: {
      Modification mod("Phosphopantetheine", "Phosphopantetheine", 340.085794, 340.333000);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 50: {
      Modification mod("FAD", "Flavin adenine dinucleotide", 783.141486, 783.533900);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 51: {
      Modification mod("Tripalmitate", "N-acyl diglyceride cysteine", 788.725777, 789.304900);
      mod.addSpecificity('C', PROTEIN_N);
      return mod;
    }
    case 52: {
      Modification mod("Guanidinyl", "Guanidination", 42.021798, 42.040000);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 53: {
      Modification mod("HNE", "4-hydroxynonenal (HNE)", 156.115030, 156.222100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('A', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 54: {
      Modification mod("Glucuronyl", "hexuronic acid", 176.032088, 176.124100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 55: {
      Modification mod("Glutathione", "glutathione disulfide", 305.068156, 305.307600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 56: {
      Modification mod("Acetyl:2H(3)", "Acetate labeling reagent (N-term & K) (heavy form, +3amu)", 45.029395, 45.055200);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 58: {
      Modification mod("Propionyl", "Propionate labeling reagent light form (N-term & K)", 56.026215, 56.063300);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 59: {
      Modification mod("Propionyl:13C(3)", "Propionate labeling reagent heavy form (+3amu), N-term & K", 59.036279, 59.041200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 60: {
      Modification mod("GIST-Quat", "Quaternary amine labeling reagent light form (N-term & K)", 127.099714, 127.184200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 61: {
      Modification mod("GIST-Quat:2H(3)", "Quaternary amine labeling reagent heavy (+3amu) form, N-term & K", 130.118544, 130.202700);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 62: {
      Modification mod("GIST-Quat:2H(6)", "Quaternary amine labeling reagent heavy form (+6amu), N-term & K", 133.137375, 133.221200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 63: {
      Modification mod("GIST-Quat:2H(9)", "Quaternary amine labeling reagent heavy form (+9amu), N-term & K", 136.156205, 136.239700);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 64: {
      Modification mod("Succinyl", "Succinic anhydride labeling reagent light form (N-term & K)", 100.016044, 100.072800);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 65: {
      Modification mod("Succinyl:2H(4)", "Succinic anhydride labeling reagent, heavy form (+4amu, 4H2), N-term & K", 104.041151, 104.097400);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 66: {
      Modification mod("Succinyl:13C(4)", "Succinic anhydride labeling reagent, heavy form (+4amu, 4C13), N-term & K", 104.029463, 104.043400);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 357: {
      Modification mod("probiotinhydrazide", "oxidized proline biotinylated with biotin hydrazide", 258.115047, 258.340500);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 359: {
      Modification mod("Pro->pyro-Glu", "proline oxidation to pyroglutamic acid", 13.979265, 13.983500);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 348: {
      Modification mod("His->Asn", "His->Asn substitution", -23.015984, -23.036600);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 349: {
      Modification mod("His->Asp", "His->Asp substitution", -22.031969, -22.051900);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 350: {
      Modification mod("Trp->Hydroxykynurenin", "tryptophan oxidation to hydroxykynurenin", 19.989829, 19.988100);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 256: {
      Modification mod("Delta:H(4)C(3)", "Propionaldehyde +40", 40.031300, 40.063900);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 255: {
      Modification mod("Delta:H(4)C(2)", "Acetaldehyde +28", 28.031300, 28.053200);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 368: {
      Modification mod("Cys->Dha", "Dehydroalanine (from Cysteine)", -33.987721, -34.080900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 344: {
      Modification mod("Arg->GluSA", "Arginine oxidation to glutamic semialdehyde", -43.053433, -43.071100);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 345: {
      Modification mod("Trioxidation", "cysteine oxidation to cysteic acid", 47.984744, 47.998200);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 89: {
      Modification mod("Iminobiotin", "Iminobiotinylation", 225.093583, 225.310600);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 90: {
      Modification mod("ESP", "ESP-Tag light d0", 338.177647, 338.468200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 91: {
      Modification mod("ESP:2H(10)", "ESP-Tag heavy d10", 348.240414, 348.529900);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 92: {
      Modification mod("NHS-LC-Biotin", "NHS-LC-Biotin", 339.161662, 339.453000);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 93: {
      Modification mod("EDT-maleimide-PEO-biotin", "EDT-maleimide-PEO-biotin", 601.206246, 601.802100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 94: {
      Modification mod("IMID", "IMID d0", 68.037448, 68.077300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 95: {
      Modification mod("IMID:2H(4)", "IMID d4", 72.062555, 72.101900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 353: {
      Modification mod("Lysbiotinhydrazide", "oxidized Lysine biotinylated with biotin hydrazide", 241.088497, 241.310000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 97: {
      Modification mod("Propionamide:2H(3)", "Acrylamide d3", 74.055944, 74.096400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 354: {
      Modification mod("Nitro", "Oxidation to nitro", 44.985078, 44.997600);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 105: {
      Modification mod("ICAT-C", "Applied Biosystems cleavable ICAT(TM) light", 227.126991, 227.260300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 254: {
      Modification mod("Delta:H(2)C(2)", "Acetaldehyde +26", 26.015650, 26.037300);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 351: {
      Modification mod("Trp->Kynurenin", "tryptophan oxidation to kynurenin", 3.994915, 3.988700);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 352: {
      Modification mod("Lys->Allysine", "Lysine oxidation to aminoadipic semialdehyde", -1.031634, -1.031100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 106: {
      Modification mod("ICAT-C:13C(9)", "Applied Biosystems cleavable ICAT(TM) heavy", 236.157185, 236.194200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 107: {
      Modification mod("FormylMet", "Addition of N-formyl met", 159.035399, 159.206200);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 108: {
      Modification mod("Nethylmaleimide", "N-ethylmaleimide on cysteines", 125.047679, 125.125300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 112: {
      Modification mod("OxLysBiotinRed", "Oxidized lysine biotinylated with biotin-LC-hydrazide, reduced", 354.172562, 354.467600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 119: {
      Modification mod("IBTP", "Thio Ether Formation - BTP Adduct", 316.138088, 316.375900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 113: {
      Modification mod("OxLysBiotin", "Oxidized lysine biotinylated with biotin-LC-hydrazide", 352.156911, 352.451800);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 114: {
      Modification mod("OxProBiotinRed", "Oxidized proline biotinylated with biotin-LC-hydrazide, reduced", 371.199111, 371.498200);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 115: {
      Modification mod("OxProBiotin", "Oxidized Proline biotinylated with biotin-LC-hydrazide", 369.183461, 369.482300);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 116: {
      Modification mod("OxArgBiotin", "Oxidized arginine biotinylated with biotin-LC-hydrazide", 310.135113, 310.411800);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 117: {
      Modification mod("OxArgBiotinRed", "Oxidized arginine biotinylated with biotin-LC-hydrazide, reduced", 312.150763, 312.427700);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 118: {
      Modification mod("EDT-iodoacetyl-PEO-biotin", "EDT-iodo-PEO-biotin", 490.174218, 490.703400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 121: {
      Modification mod("GG", "ubiquitinylation residue", 114.042927, 114.102600);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 122: {
      Modification mod("Formyl", "Formylation", 27.994915, 28.010100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 123: {
      Modification mod("ICAT-H", "N-iodoacetyl, p-chlorobenzyl-12C6-glucamine", 345.097915, 345.775400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 124: {
      Modification mod("ICAT-H:13C(6)", "N-iodoacetyl, p-chlorobenzyl-13C6-glucamine", 351.118044, 351.731300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 530: {
      Modification mod("Cation:K", "Replacement of proton by potassium", 37.955882, 38.090400);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 126: {
      Modification mod("Xlink:DTSSP[88]", "Cleaved and reduced DSP/DTSSP crosslinker", 87.998285, 88.128300);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1897: {
      Modification mod("Xlink:EGS[226]", "Intact EGS cross-linker", 226.047738, 226.182800);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 127: {
      Modification mod("Fluoro", "fluorination", 17.990578, 17.990500);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 128: {
      Modification mod("Fluorescein", "5-Iodoacetamidofluorescein (Molecular Probe, Eugene, OR)", 387.074287, 387.341700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 129: {
      Modification mod("Iodo", "Iodination", 125.896648, 125.896500);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 130: {
      Modification mod("Diiodo", "di-Iodination", 251.793296, 251.793100);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 131: {
      Modification mod("Triiodo", "tri-Iodination", 377.689944, 377.689600);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 134: {
      Modification mod("Myristoleyl", "(cis-delta 5)-tetradecaenoyl", 208.182715, 208.339800);
      mod.addSpecificity('G', PROTEIN_N);
      return mod;
    }
    case 360: {
      Modification mod("Pro->Pyrrolidinone", "Proline oxidation to pyrrolidinone", -30.010565, -30.026000);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 135: {
      Modification mod("Myristoyl+Delta:H(-4)", "(cis,cis-delta 5, delta 8)-tetradecadienoyl", 206.167065, 206.323900);
      mod.addSpecificity('G', PROTEIN_N);
      return mod;
    }
    case 136: {
      Modification mod("Benzoyl", "labeling reagent light form (N-term & K)", 104.026215, 104.106100);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 137: {
      Modification mod("Hex(5)HexNAc(2)", "M5/Man5", 1216.422863, 1217.088000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 139: {
      Modification mod("Dansyl", "5-dimethylaminonaphthalene-1-sulfonyl", 233.051049, 233.286200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 140: {
      Modification mod("a-type-ion", "ISD a-series (C-Term)", -46.005479, -46.025400);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 141: {
      Modification mod("Amidine", "amidination of lysines or N-terminal amines with methyl acetimidate", 41.026549, 41.051900);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 142: {
      Modification mod("HexNAc(1)dHex(1)", "HexNAc1dHex1", 349.137281, 349.333700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 143: {
      Modification mod("HexNAc(2)", "HexNAc2", 406.158745, 406.385000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 144: {
      Modification mod("Hex(3)", "Hex3", 486.158471, 486.421800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 145: {
      Modification mod("HexNAc(1)dHex(2)", "HexNAc1dHex2", 495.195190, 495.474900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 146: {
      Modification mod("Hex(1)HexNAc(1)dHex(1)", "Hex1HexNAc1dHex1", 511.190105, 511.474300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 147: {
      Modification mod("HexNAc(2)dHex(1)", "HexNAc2dHex1", 552.216654, 552.526200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 148: {
      Modification mod("Hex(1)HexNAc(2)", "Hex1HexNAc2", 568.211569, 568.525600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 149: {
      Modification mod("Hex(1)HexNAc(1)NeuAc(1)", "Hex1HexNAc1NeuAc1", 656.227613, 656.587700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 150: {
      Modification mod("HexNAc(2)dHex(2)", "HexNAc2dHex2", 698.274563, 698.667400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 151: {
      Modification mod("Hex(1)HexNAc(2)Pent(1)", "Hex1HexNAc2Pent1", 700.253828, 700.640300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 152: {
      Modification mod("Hex(1)HexNAc(2)dHex(1)", "Hex1HexNAc2dHex1", 714.269478, 714.666800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 153: {
      Modification mod("Hex(2)HexNAc(2)", "Hex2HexNAc2", 730.264392, 730.666200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 154: {
      Modification mod("Hex(3)HexNAc(1)Pent(1)", "Hex3HexNAc1Pent1", 821.280102, 821.728900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 155: {
      Modification mod("Hex(1)HexNAc(2)dHex(1)Pent(1)", "Hex1HexNAc2dHex1Pent1", 846.311736, 846.781500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 156: {
      Modification mod("Hex(1)HexNAc(2)dHex(2)", "Hex1HexNAc2dHex2", 860.327386, 860.808000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 157: {
      Modification mod("Hex(2)HexNAc(2)Pent(1)", "Hex2HexNAc2Pent1", 862.306651, 862.780900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 158: {
      Modification mod("Hex(2)HexNAc(2)dHex(1)", "Hex2HexNAc2dHex1", 876.322301, 876.807400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 159: {
      Modification mod("Hex(3)HexNAc(2)", "M3/Man3", 892.317216, 892.806800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 160: {
      Modification mod("Hex(1)HexNAc(1)NeuAc(2)", "Hex HexNAc NeuAc(2) ---OR--- Hex HexNAc(3) HexA", 947.323029, 947.842300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 161: {
      Modification mod("Hex(3)HexNAc(2)Phos(1)", "Hex(3) HexNAc(2) Phos", 972.283547, 972.786700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 162: {
      Modification mod("Delta:S(-1)Se(1)", "Selenium replaces sulfur", 47.944449, 46.895000);
      mod.addSpecificity('M', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 171: {
      Modification mod("NBS:13C(6)", "Shimadzu NBS-13C", 159.008578, 159.114400);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 329: {
      Modification mod("Methyl:2H(3)13C(1)", "monomethylation", 18.037835, 18.037700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 330: {
      Modification mod("Dimethyl:2H(6)13C(2)", "dimethylation", 36.075670, 36.075400);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 172: {
      Modification mod("NBS", "Shimadzu NBS-12C", 152.988449, 153.158500);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 170: {
      Modification mod("Delta:H(-1)N(-1)18O(1)", "glycosylated asparagine 18O labeling", 2.988261, 2.984500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 195: {
      Modification mod("QAT", "APTA-d0", 171.149738, 171.260000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 176: {
      Modification mod("BHT", "Michael addition of BHT quinone methide to Cysteine and Lysine", 218.167065, 218.334600);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 327: {
      Modification mod("Delta:H(4)C(2)O(-1)S(1)", "S-Ethylcystine from Serine", 44.008456, 44.118800);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 178: {
      Modification mod("DAET", "phosphorylation to amine thiol", 87.050655, 87.186600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 369: {
      Modification mod("Pro->Pyrrolidone", "Pyrrolidone from Proline", -27.994915, -28.010100);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 184: {
      Modification mod("Label:13C(9)", "13C(9) Silac label", 9.030193, 8.933900);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 185: {
      Modification mod("Label:13C(9)+Phospho", "C13 label (Phosphotyrosine)", 88.996524, 88.913800);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 188: {
      Modification mod("Label:13C(6)", "13C(6) Silac label", 6.020129, 5.955900);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 186: {
      Modification mod("HPG", "Hydroxyphenylglyoxal arginine", 132.021129, 132.116200);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 187: {
      Modification mod("2HPG", "bis(hydroxphenylglyoxal) arginine", 282.052824, 282.247600);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 196: {
      Modification mod("QAT:2H(3)", "APTA d3", 174.168569, 174.278400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 193: {
      Modification mod("Label:18O(2)", "O18 label at both C-terminal oxygens", 4.008491, 3.999500);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 194: {
      Modification mod("AccQTag", "6-aminoquinolyl-N-hydroxysuccinimidyl carbamate", 170.048013, 170.167400);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 199: {
      Modification mod("Dimethyl:2H(4)", "DiMethyl-CHD2", 32.056407, 32.077800);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 197: {
      Modification mod("EQAT", "EAPTA d0", 184.157563, 184.278600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 198: {
      Modification mod("EQAT:2H(5)", "EAPTA d5", 189.188947, 189.309400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 200: {
      Modification mod("Ethanedithiol", "EDT", 75.980527, 76.183800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 212: {
      Modification mod("NEIAA:2H(5)", "N-ethyl iodoacetamide-d5", 90.084148, 90.135300);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 205: {
      Modification mod("Delta:H(6)C(6)O(1)", "Acrolein addition +94", 94.041865, 94.111200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 206: {
      Modification mod("Delta:H(4)C(3)O(1)", "Acrolein addition +56", 56.026215, 56.063300);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 207: {
      Modification mod("Delta:H(2)C(3)", "Acrolein addition +38", 38.015650, 38.048000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 208: {
      Modification mod("Delta:H(4)C(6)", "Acrolein addition +76", 76.031300, 76.096000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 209: {
      Modification mod("Delta:H(8)C(6)O(2)", "Acrolein addition +112", 112.052430, 112.126500);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 213: {
      Modification mod("ADP-Ribosyl", "ADP  Ribose addition", 541.061110, 541.300500);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 211: {
      Modification mod("NEIAA", "N-ethyl iodoacetamide-d0", 85.052764, 85.104500);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 214: {
      Modification mod("iTRAQ4plex", "Representative mass and accurate mass for 116 & 117", 144.102063, 144.154400);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 253: {
      Modification mod("Crotonaldehyde", "Crotonaldehyde", 70.041865, 70.089800);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 340: {
      Modification mod("Bromo", "bromination", 77.910511, 78.896100);
      mod.addSpecificity('F', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 342: {
      Modification mod("Amino", "Tyrosine oxidation to 2-aminotyrosine", 15.010899, 15.014600);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 343: {
      Modification mod("Argbiotinhydrazide", "oxidized Arginine biotinylated with biotin hydrazide", 199.066699, 199.270000);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 258: {
      Modification mod("Label:18O(1)", "O18 Labeling", 2.004246, 1.999800);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 259: {
      Modification mod("Label:13C(6)15N(2)", "13C(6) 15N(2) Silac label", 8.014199, 7.942700);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 260: {
      Modification mod("Thiophospho", "Thiophosphorylation", 95.943487, 96.045500);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 261: {
      Modification mod("SPITC", "4-sulfophenyl isothiocyanate", 214.971084, 215.249500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 243: {
      Modification mod("IGBP", "Light IDBEST tag for quantitation", 296.016039, 297.147800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 270: {
      Modification mod("Cytopiloyne", "nucleophilic addtion to cytopiloyne", 362.136553, 362.373800);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('P', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 271: {
      Modification mod("Cytopiloyne+water", "nucleophilic addition to cytopiloyne+H2O", 380.147118, 380.389100);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 267: {
      Modification mod("Label:13C(6)15N(4)", "13C(6) 15N(4) Silac label", 10.008269, 9.929600);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 269: {
      Modification mod("Label:13C(9)15N(1)", "13C(9) 15N(1) Silac label", 10.027228, 9.927300);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 262: {
      Modification mod("Label:2H(3)", "Trideuteration", 3.018830, 3.018500);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 268: {
      Modification mod("Label:13C(5)15N(1)", "13C(5) 15N(1) Silac label", 6.013809, 5.956700);
      mod.addSpecificity('M', ANYWHERE);
      mod.addSpecificity('P', ANYWHERE);
      mod.addSpecificity('V', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 264: {
      Modification mod("PET", "phosphorylation to pyridyl thiol", 121.035005, 121.202800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 272: {
      Modification mod("CAF", "sulfonation of N-terminus", 135.983029, 136.126500);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1905: {
      Modification mod("Xlink:BS2G[96]", "Intact BS2-G crosslinker", 96.021129, 96.084100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 275: {
      Modification mod("Nitrosyl", "nitrosylation", 28.990164, 28.998200);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 2022: {
      Modification mod("Ser/Thr-KDO", "Glycosylation of Serine/Threonine residues with KDO", 220.058303, 220.176700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 276: {
      Modification mod("AEBS", "Aminoethylbenzenesulfonylation", 183.035399, 183.227600);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 278: {
      Modification mod("Ethanolyl", "Ethanolation", 44.026215, 44.052600);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 987: {
      Modification mod("Label:13C(6)15N(2)+Dimethyl", "Dimethyl 13C(6)15N(2) Silac label", 36.045499, 35.995900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 371: {
      Modification mod("HMVK", "Michael addition of hydroxymethylvinyl ketone to cysteine", 86.036779, 86.089200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 280: {
      Modification mod("Ethyl", "Ethylation", 28.031300, 28.053200);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 281: {
      Modification mod("CoenzymeA", "Cysteine modified Coenzyme A", 765.099560, 765.518200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 528: {
      Modification mod("Methyl+Deamidated", "Deamidation followed by a methylation", 14.999666, 15.011300);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 529: {
      Modification mod("Delta:H(5)C(2)", "Dimethylation of proline residue", 29.039125, 29.061100);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 284: {
      Modification mod("Methyl:2H(2)", "Deuterium Methylation of Lysine", 16.028204, 16.038900);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 285: {
      Modification mod("SulfanilicAcid", "Light Sulfanilic Acid (SA) C12", 155.004099, 155.174400);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 286: {
      Modification mod("SulfanilicAcid:13C(6)", "Heavy Sulfanilic Acid (SA) C13", 161.024228, 161.130300);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 289: {
      Modification mod("Biotin-PEO-Amine", "Biotin polyethyleneoxide amine", 356.188212, 356.483500);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('c', PROTEIN_C);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 288: {
      Modification mod("Trp->Oxolactone", "Tryptophan oxidation to oxolactone", 13.979265, 13.983500);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 290: {
      Modification mod("Biotin-HPDP", "Pierce EZ-Link Biotin-HPDP", 428.191582, 428.612400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 291: {
      Modification mod("Delta:Hg(1)", "Mercury Mercaptan", 201.970617, 200.590000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 292: {
      Modification mod("IodoU-AMP", "(Iodo)-uracil MP", 322.020217, 322.165400);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 293: {
      Modification mod("CAMthiopropanoyl", "3-(carbamidomethylthio)propanoyl", 145.019749, 145.179600);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 294: {
      Modification mod("IED-Biotin", "biotinoyl-iodoacetyl-ethylenediamine", 326.141261, 326.414500);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 295: {
      Modification mod("dHex", "Fucose", 146.057909, 146.141200);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 298: {
      Modification mod("Methyl:2H(3)", "deuterated methyl ester", 17.034480, 17.045100);
      mod.addSpecificity('c', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 299: {
      Modification mod("Carboxy", "Carboxylation", 43.989829, 44.009500);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('M', PROTEIN_N);
      return mod;
    }
    case 301: {
      Modification mod("Bromobimane", "Monobromobimane derivative", 190.074228, 190.198600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 302: {
      Modification mod("Menadione", "Menadione quinone derivative", 170.036779, 170.164100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 303: {
      Modification mod("DeStreak", "Cysteine mercaptoethanol", 75.998285, 76.117600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 305: {
      Modification mod("dHex(1)Hex(3)HexNAc(4)", "FA2/G0F", 1444.533870, 1445.333100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 307: {
      Modification mod("dHex(1)Hex(4)HexNAc(4)", "FA2G1/G1F", 1606.586693, 1607.473700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 2035: {
      Modification mod("Pro+O(2)", "Photo-induced Proline adduct", 129.042593, 129.114000);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 308: {
      Modification mod("dHex(1)Hex(5)HexNAc(4)", "FA2G2/G2F", 1768.639517, 1769.614300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 309: {
      Modification mod("Hex(3)HexNAc(4)", "A2/G0", 1298.475961, 1299.191900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 310: {
      Modification mod("Hex(4)HexNAc(4)", "A2G1/G1", 1460.528784, 1461.332500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 311: {
      Modification mod("Hex(5)HexNAc(4)", "A2G2/G2", 1622.581608, 1623.473100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 312: {
      Modification mod("Cysteinyl", "Cysteinylation", 119.004099, 119.142300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 313: {
      Modification mod("Lys-loss", "Loss of Lysine", -128.094963, -128.172300);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('K', PROTEIN_C);
      return mod;
    }
    case 314: {
      Modification mod("Nmethylmaleimide", "Nmethylmaleimide", 111.032028, 111.098700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 494: {
      Modification mod("CyDye-Cy3", "Cy3 CyDye DIGE Fluor saturation dye", 672.298156, 672.833500);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 316: {
      Modification mod("DimethylpyrroleAdduct", "2,5-dimethypyrrole", 78.046950, 78.111800);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 318: {
      Modification mod("Delta:H(2)C(5)", "MDA adduct +62", 62.015650, 62.069400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 319: {
      Modification mod("Delta:H(2)C(3)O(1)", "MDA adduct +54", 54.010565, 54.047400);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 320: {
      Modification mod("Nethylmaleimide+water", "Nethylmaleimidehydrolysis", 143.058243, 143.140600);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 768: {
      Modification mod("Methyl+Acetyl:2H(3)", "Mono-methylated lysine labelled with Acetyl_heavy", 59.045045, 59.081700);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 323: {
      Modification mod("Xlink:B10621", "bis-((N-iodoacetyl)piperazinyl)sulfonerhodamine", 713.093079, 713.562600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 324: {
      Modification mod("Xlink:DTBP[87]", "Cleaved and reduced DTBP crosslinker", 87.014270, 87.143500);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 325: {
      Modification mod("FP-Biotin", "10-ethoxyphosphinyl-N-(biotinamidopentyl)decanamide", 572.316129, 572.740500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 332: {
      Modification mod("Thiophos-S-S-biotin", "thiophosphate labeled with biotin-HPDP", 525.142894, 525.665800);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 333: {
      Modification mod("Can-FP-biotin", "6-N-biotinylaminohexyl isopropyl phosphate", 447.195679, 447.529100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 335: {
      Modification mod("HNE+Delta:H(2)", "reduced 4-Hydroxynonenal", 158.130680, 158.238000);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 361: {
      Modification mod("Thrbiotinhydrazide", "oxidized Threonine biotinylated with biotin hydrazide", 240.104482, 240.325200);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 337: {
      Modification mod("Methylamine", "Michael addition with methylamine", 13.031634, 13.041800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 362: {
      Modification mod("Diisopropylphosphate", "O-Diisopropylphosphorylation", 164.060231, 164.139400);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 363: {
      Modification mod("Isopropylphospho", "O-Isopropylphosphorylation", 122.013281, 122.059600);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 364: {
      Modification mod("ICPL:13C(6)", "Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, heavy form", 111.041593, 111.050000);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 893: {
      Modification mod("CarbamidomethylDTT", "Carbamidomethylated DTT modification of cysteine", 209.018035, 209.286400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 365: {
      Modification mod("ICPL", "Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, light form", 105.021464, 105.094100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 366: {
      Modification mod("Deamidated:18O(1)", "Deamidation in presence of O18", 2.988261, 2.984500);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 372: {
      Modification mod("Arg->Orn", "Ornithine from Arginine", -42.021798, -42.040000);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 531: {
      Modification mod("Cation:Cu[I]", "Replacement of proton by copper", 61.921774, 62.538100);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 374: {
      Modification mod("Dehydro", "Half of a disulfide bridge", -1.007825, -1.007900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 375: {
      Modification mod("Diphthamide", "Diphthamide", 142.110613, 142.198900);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 376: {
      Modification mod("Hydroxyfarnesyl", "hydroxyfarnesyl", 220.182715, 220.350500);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 377: {
      Modification mod("Diacylglycerol", "diacylglycerol", 576.511761, 576.933400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 378: {
      Modification mod("Carboxyethyl", "carboxyethyl", 72.021129, 72.062700);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 379: {
      Modification mod("Hypusine", "hypusine", 87.068414, 87.120400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 380: {
      Modification mod("Retinylidene", "retinal", 266.203451, 266.420400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 381: {
      Modification mod("Lys->AminoadipicAcid", "alpha-amino adipic acid", 14.963280, 14.968300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 382: {
      Modification mod("Cys->PyruvicAcid", "pyruvic acid from N-term cys", -33.003705, -33.096100);
      mod.addSpecificity('C', PROTEIN_N);
      return mod;
    }
    case 385: {
      Modification mod("Ammonia-loss", "Loss of ammonia", -17.026549, -17.030500);
      mod.addSpecificity('C', ANY_N);
      mod.addSpecificity('S', PROTEIN_N);
      mod.addSpecificity('T', PROTEIN_N);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 387: {
      Modification mod("Phycocyanobilin", "phycocyanobilin", 586.279135, 586.678000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 388: {
      Modification mod("Phycoerythrobilin", "phycoerythrobilin", 588.294785, 588.693900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 389: {
      Modification mod("Phytochromobilin", "phytochromobilin", 584.263485, 584.662100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 390: {
      Modification mod("Heme", "heme", 616.177295, 616.487300);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 391: {
      Modification mod("Molybdopterin", "molybdopterin", 521.884073, 520.266800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 392: {
      Modification mod("Quinone", "quinone", 29.974179, 29.982900);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 393: {
      Modification mod("Glucosylgalactosyl", "glucosylgalactosyl hydroxylysine", 340.100562, 340.280600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 394: {
      Modification mod("GPIanchor", "glycosylphosphatidylinositol", 123.008530, 123.047700);
      mod.addSpecificity('c', PROTEIN_C);
      return mod;
    }
    case 395: {
      Modification mod("PhosphoribosyldephosphoCoA", "phosphoribosyl dephospho-coenzyme A", 881.146904, 881.633500);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 396: {
      Modification mod("GlycerylPE", "glycerylphosphorylethanolamine", 197.045310, 197.126200);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 397: {
      Modification mod("Triiodothyronine", "triiodo", 469.716159, 469.785000);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 398: {
      Modification mod("Thyroxine", "tetraiodo", 595.612807, 595.681500);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 400: {
      Modification mod("Tyr->Dha", "Dehydroalanine (from Tyrosine)", -94.041865, -94.111200);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 401: {
      Modification mod("Didehydro", "2-amino-3-oxo-butanoic_acid", -2.015650, -2.015900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('K', ANY_C);
      return mod;
    }
    case 402: {
      Modification mod("Cys->Oxoalanine", "oxoalanine", -17.992806, -18.081500);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 403: {
      Modification mod("Ser->LacticAcid", "lactic acid from N-term Ser", -15.010899, -15.014600);
      mod.addSpecificity('S', PROTEIN_N);
      return mod;
    }
    case 451: {
      Modification mod("GluGlu", "diglutamyl", 258.085186, 258.228000);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', PROTEIN_C);
      return mod;
    }
    case 405: {
      Modification mod("Phosphoadenosine", "AMP", 329.052520, 329.205900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 450: {
      Modification mod("Glu", "monoglutamyl", 129.042593, 129.114000);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', PROTEIN_C);
      return mod;
    }
    case 407: {
      Modification mod("Hydroxycinnamyl", "hydroxycinnamyl", 146.036779, 146.142700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 408: {
      Modification mod("Glycosyl", "glycosyl-L-hydroxyproline", 148.037173, 148.114000);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 409: {
      Modification mod("FMNH", "flavin mononucleotide", 454.088965, 454.327900);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 410: {
      Modification mod("Archaeol", "S-diphytanylglycerol diether", 634.662782, 635.141700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 411: {
      Modification mod("Phenylisocyanate", "phenyl isocyanate", 119.037114, 119.120700);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 412: {
      Modification mod("Phenylisocyanate:2H(5)", "d5-phenyl isocyanate", 124.068498, 124.151500);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 413: {
      Modification mod("Phosphoguanosine", "phospho-guanosine", 345.047435, 345.205300);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 414: {
      Modification mod("Hydroxymethyl", "hydroxymethyl", 30.010565, 30.026000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 415: {
      Modification mod("MolybdopterinGD+Delta:S(-1)Se(1)", "L-selenocysteinyl molybdenum bis(molybdopterin guanine dinucleotide)", 1620.930224, 1618.909600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 416: {
      Modification mod("Dipyrrolylmethanemethyl", "dipyrrolylmethanemethyl", 418.137616, 418.397300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 417: {
      Modification mod("PhosphoUridine", "uridine phosphodiester", 306.025302, 306.166000);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 419: {
      Modification mod("Glycerophospho", "glycerophospho", 154.003110, 154.058400);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 420: {
      Modification mod("Carboxy->Thiocarboxy", "thiocarboxylic acid", 15.977156, 16.065600);
      mod.addSpecificity('G', PROTEIN_C);
      return mod;
    }
    case 421: {
      Modification mod("Sulfide", "persulfide", 31.972071, 32.065000);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 422: {
      Modification mod("PyruvicAcidIminyl", "N-pyruvic acid 2-iminyl", 70.005479, 70.046800);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('V', PROTEIN_N);
      mod.addSpecificity('C', PROTEIN_N);
      return mod;
    }
    case 423: {
      Modification mod("Delta:Se(1)", "selenyl", 79.916520, 78.960000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 424: {
      Modification mod("MolybdopterinGD", "molybdenum bis(molybdopterin guanine dinucleotide)", 1572.985775, 1572.014600);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('U', ANYWHERE);
      return mod;
    }
    case 425: {
      Modification mod("Dioxidation", "dihydroxy", 31.989829, 31.998800);
      mod.addSpecificity('U', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      mod.addSpecificity('M', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('P', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 426: {
      Modification mod("Octanoyl", "octanoyl", 126.104465, 126.196200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 428: {
      Modification mod("PhosphoHexNAc", "N-acetylglucosamine-1-phosphoryl", 283.045704, 283.172400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 429: {
      Modification mod("PhosphoHex", "phosphoglycosyl-D-mannose-1-phosphoryl", 242.019154, 242.120500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 431: {
      Modification mod("Palmitoleyl", "palmitoleyl", 236.214016, 236.392900);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 432: {
      Modification mod("Cholesterol", "cholesterol ester", 368.344302, 368.638300);
      mod.addSpecificity('c', PROTEIN_C);
      return mod;
    }
    case 433: {
      Modification mod("Didehydroretinylidene", "3,4-didehydroretinylidene", 264.187801, 264.404600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 434: {
      Modification mod("CHDH", "cis-14-hydroxy-10,13-dioxo-7-heptadecenoic ester", 294.183109, 294.385900);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 435: {
      Modification mod("Methylpyrroline", "4-methyl-delta-1-pyrroline-5-carboxyl", 109.052764, 109.125900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 436: {
      Modification mod("Hydroxyheme", "hydroxyheme", 614.161645, 614.471400);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 437: {
      Modification mod("MicrocinC7", "(3-aminopropyl)(L-aspartyl-1-amino)phosphoryl-5-adenosine", 386.110369, 386.300300);
      mod.addSpecificity('c', PROTEIN_C);
      return mod;
    }
    case 438: {
      Modification mod("Cyano", "cyano", 24.995249, 25.009500);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 439: {
      Modification mod("Diironsubcluster", "hydrogenase diiron subcluster", 342.786916, 342.876000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 440: {
      Modification mod("Amidino", "amidino", 42.021798, 42.040000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 442: {
      Modification mod("FMN", "O3-(riboflavin phosphoryl)", 438.094051, 438.328500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 443: {
      Modification mod("FMNC", "S-(4a-FMN)", 456.104615, 456.343800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 444: {
      Modification mod("CuSMo", "copper sulfido molybdopterin cytosine dinuncleotide", 922.834855, 922.067000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 445: {
      Modification mod("Hydroxytrimethyl", "5-hydroxy-N6,N6,N6-trimethyl", 59.049690, 59.087100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 447: {
      Modification mod("Deoxy", "reduction", -15.994915, -15.999400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 448: {
      Modification mod("Microcin", "microcin E492 siderophore ester from serine", 831.197041, 831.687100);
      mod.addSpecificity('c', PROTEIN_C);
      return mod;
    }
    case 449: {
      Modification mod("Decanoyl", "lipid", 154.135765, 154.249300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 452: {
      Modification mod("GluGluGlu", "triglutamyl", 387.127779, 387.341900);
      mod.addSpecificity('c', PROTEIN_C);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 453: {
      Modification mod("GluGluGluGlu", "tetraglutamyl", 516.170373, 516.455900);
      mod.addSpecificity('c', PROTEIN_C);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 454: {
      Modification mod("HexN", "Hexosamine", 161.068808, 161.155800);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 455: {
      Modification mod("Xlink:DMP[154]", "Free monolink of DMP crosslinker", 154.110613, 154.209600);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 457: {
      Modification mod("NDA", "naphthalene-2,3-dicarboxaldehyde", 175.042199, 175.185500);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 464: {
      Modification mod("SPITC:13C(6)", "4-sulfophenyl isothiocyanate (Heavy C13)", 220.991213, 221.205400);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 477: {
      Modification mod("TMAB:2H(9)", "d9-4-trimethyllammoniumbutyryl-", 137.164030, 137.247600);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 476: {
      Modification mod("TMAB", "4-trimethyllammoniumbutyryl-", 128.107539, 128.192200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 478: {
      Modification mod("FTC", "fluorescein-5-thiosemicarbazide", 421.073241, 421.425900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('P', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 472: {
      Modification mod("AEC-MAEC", "aminoethylcysteine", 59.019355, 59.133400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 493: {
      Modification mod("BADGE", "Bisphenol A diglycidyl ether derivative", 340.167459, 340.412900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 481: {
      Modification mod("Label:2H(4)", "4,4,5,5-D4 Lysine", 4.025107, 4.024600);
      mod.addSpecificity('A', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('U', ANYWHERE);
      return mod;
    }
    case 490: {
      Modification mod("Hep", "Heptose", 192.063388, 192.166600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 495: {
      Modification mod("CyDye-Cy5", "Cy5 CyDye DIGE Fluor saturation dye", 684.298156, 684.844200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 488: {
      Modification mod("DHP", "Dehydropyrrolizidine alkaloid (dehydroretronecine) on cysteines", 118.065674, 118.155800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 498: {
      Modification mod("BHTOH", "Michael addition of t-butyl hydroxylated BHT (BHTOH) to C, H or K", 234.161980, 234.334000);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 499: {
      Modification mod("IGBP:13C(2)", "Heavy IDBEST tag for quantitation", 298.022748, 299.133100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 500: {
      Modification mod("Nmethylmaleimide+water", "Nmethylmaleimidehydrolysis", 129.042593, 129.114000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 501: {
      Modification mod("PyMIC", "3-methyl-2-pyridyl isocyanate", 134.048013, 134.135300);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 503: {
      Modification mod("LG-lactam-K", "Levuglandinyl - lysine lactam adduct", 332.198760, 332.433900);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 519: {
      Modification mod("BisANS", "4,4\'-dianilino-1,1\'-binaphthyl-5,5\'-disulfonic acid", 594.091928, 594.656900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 520: {
      Modification mod("Piperidine", "Piperidination", 68.062600, 68.117000);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 518: {
      Modification mod("Diethyl", "Diethylation, analogous to Dimethylation", 56.062600, 56.106300);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 504: {
      Modification mod("LG-Hlactam-K", "Levuglandinyl - lysine hydroxylactam adduct", 348.193674, 348.433300);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 510: {
      Modification mod("Dimethyl:2H(4)13C(2)", "DiMethyl-C13HD2", 34.063117, 34.063100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 513: {
      Modification mod("C8-QAT", "[3-(2,5)-Dioxopyrrolidin-1-yloxycarbonyl)-propyl]dimethyloctylammonium", 227.224915, 227.386200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 512: {
      Modification mod("Hex(2)", "Lactosylation", 324.105647, 324.281200);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 505: {
      Modification mod("LG-lactam-R", "Levuglandinyl - arginine lactam adduct", 290.176961, 290.393900);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1036: {
      Modification mod("Withaferin", "Modification of cystein by withaferin", 470.266839, 470.597700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1037: {
      Modification mod("Biotin:Thermo-88317", "desthiobiotin fluorophosphonate", 443.291294, 443.560300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 525: {
      Modification mod("CLIP_TRAQ_2", "CLIP_TRAQ_2", 141.098318, 141.175600);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 506: {
      Modification mod("LG-Hlactam-R", "Levuglandinyl - arginine hydroxylactam adduct", 306.171876, 306.393300);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 522: {
      Modification mod("Maleimide-PEO2-Biotin", "Maleimide-Biotin", 525.225719, 525.618300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 523: {
      Modification mod("Sulfo-NHS-LC-LC-Biotin", "Biot_LC_LC", 452.245726, 452.610600);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 515: {
      Modification mod("FNEM", "fluorescein-5-maleimide", 427.069202, 427.362500);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 514: {
      Modification mod("PropylNAGthiazoline", "propyl-1,2-dideoxy-2\'-methyl-alpha-D-glucopyranoso-[2,1-d]-Delta2\'-thiazoline", 232.064354, 232.276800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 526: {
      Modification mod("Dethiomethyl", "Prompt loss of side chain from oxidised Met", -48.003371, -48.107500);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 532: {
      Modification mod("iTRAQ4plex114", "Accurate mass for 114", 144.105918, 144.168000);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 533: {
      Modification mod("iTRAQ4plex115", "Accurate mass for 115", 144.099599, 144.168800);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 534: {
      Modification mod("Dibromo", "Dibromo", 155.821022, 157.792100);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 535: {
      Modification mod("LRGG", "Ubiquitination", 383.228103, 383.446000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 536: {
      Modification mod("CLIP_TRAQ_3", "CLIP_TRAQ_3", 271.148736, 271.297600);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 537: {
      Modification mod("CLIP_TRAQ_4", "CLIP_TRAQ_4", 244.101452, 244.229200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 538: {
      Modification mod("Biotin:Cayman-10141", "was 15dB-biotin", 626.386577, 626.892700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 539: {
      Modification mod("Biotin:Cayman-10013", "was PGA1-biotin", 660.428442, 660.950400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 540: {
      Modification mod("Ala->Ser", "Ala->Ser substitution", 15.994915, 15.999400);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 541: {
      Modification mod("Ala->Thr", "Ala->Thr substitution", 30.010565, 30.026000);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 542: {
      Modification mod("Ala->Asp", "Ala->Asp substitution", 43.989829, 44.009500);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 543: {
      Modification mod("Ala->Pro", "Ala->Pro substitution", 26.015650, 26.037300);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 544: {
      Modification mod("Ala->Gly", "Ala->Gly substitution", -14.015650, -14.026600);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 545: {
      Modification mod("Ala->Glu", "Ala->Glu substitution", 58.005479, 58.036100);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 546: {
      Modification mod("Ala->Val", "Ala->Val substitution", 28.031300, 28.053200);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 547: {
      Modification mod("Cys->Phe", "Cys->Phe substitution", 44.059229, 44.031000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 548: {
      Modification mod("Cys->Ser", "Cys->Ser substitution", -15.977156, -16.065600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 549: {
      Modification mod("Cys->Trp", "Cys->Trp substitution", 83.070128, 83.067000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 550: {
      Modification mod("Cys->Tyr", "Cys->Tyr substitution", 60.054144, 60.030400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 551: {
      Modification mod("Cys->Arg", "Cys->Arg substitution", 53.091927, 53.042800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 552: {
      Modification mod("Cys->Gly", "Cys->Gly substitution", -45.987721, -46.091600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 553: {
      Modification mod("Asp->Ala", "Asp->Ala substitution", -43.989829, -44.009500);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 554: {
      Modification mod("Asp->His", "Asp->His substitution", 22.031969, 22.051900);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 555: {
      Modification mod("Asp->Asn", "Asp->Asn substitution", -0.984016, -0.984800);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 556: {
      Modification mod("Asp->Gly", "Asp->Gly substitution", -58.005479, -58.036100);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 557: {
      Modification mod("Asp->Tyr", "Asp->Tyr substitution", 48.036386, 48.085900);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 558: {
      Modification mod("Asp->Glu", "Asp->Glu substitution", 14.015650, 14.026600);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 559: {
      Modification mod("Asp->Val", "Asp->Val substitution", -15.958529, -15.956300);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 560: {
      Modification mod("Glu->Ala", "Glu->Ala substitution", -58.005479, -58.036100);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 561: {
      Modification mod("Glu->Gln", "Glu->Gln substitution", -0.984016, -0.984800);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 562: {
      Modification mod("Glu->Asp", "Glu->Asp substitution", -14.015650, -14.026600);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 563: {
      Modification mod("Glu->Lys", "Glu->Lys substitution", -0.947630, -0.941700);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 564: {
      Modification mod("Glu->Gly", "Glu->Gly substitution", -72.021129, -72.062700);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 565: {
      Modification mod("Glu->Val", "Glu->Val substitution", -29.974179, -29.982900);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 566: {
      Modification mod("Phe->Ser", "Phe->Ser substitution", -60.036386, -60.096600);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 567: {
      Modification mod("Phe->Cys", "Phe->Cys substitution", -44.059229, -44.031000);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 568: {
      Modification mod("Phe->Xle", "Phe->Leu/Ile substitution", -33.984350, -34.016200);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 569: {
      Modification mod("Phe->Tyr", "Phe->Tyr substitution", 15.994915, 15.999400);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 570: {
      Modification mod("Phe->Val", "Phe->Val substitution", -48.000000, -48.042800);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 571: {
      Modification mod("Gly->Ala", "Gly->Ala substitution", 14.015650, 14.026600);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 572: {
      Modification mod("Gly->Ser", "Gly->Ser substitution", 30.010565, 30.026000);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 573: {
      Modification mod("Gly->Trp", "Gly->Trp substitution", 129.057849, 129.158600);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 574: {
      Modification mod("Gly->Glu", "Gly->Glu substitution", 72.021129, 72.062700);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 575: {
      Modification mod("Gly->Val", "Gly->Val substitution", 42.046950, 42.079700);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 576: {
      Modification mod("Gly->Asp", "Gly->Asp substitution", 58.005479, 58.036100);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 577: {
      Modification mod("Gly->Cys", "Gly->Cys substitution", 45.987721, 46.091600);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 578: {
      Modification mod("Gly->Arg", "Gly->Arg substitution", 99.079647, 99.134400);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 698: {
      Modification mod("dNIC", "deuterated Nicotinic Acid", 109.048119, 109.120500);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 580: {
      Modification mod("His->Pro", "His->Pro substitution", -40.006148, -40.024100);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 581: {
      Modification mod("His->Tyr", "His->Tyr substitution", 26.004417, 26.034000);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 582: {
      Modification mod("His->Gln", "His->Gln substitution", -9.000334, -9.010100);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 697: {
      Modification mod("NIC", "Nicotinic Acid", 105.021464, 105.094100);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 584: {
      Modification mod("His->Arg", "His->Arg substitution", 19.042199, 19.046400);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 585: {
      Modification mod("His->Xle", "His->Leu/Ile substitution", -23.974848, -23.981600);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1125: {
      Modification mod("Xle->Ala", "Leu/Ile->Ala substitution", -42.046950, -42.079700);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 588: {
      Modification mod("Xle->Thr", "Leu/Ile->Thr substitution", -12.036386, -12.053800);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 589: {
      Modification mod("Xle->Asn", "Leu/Ile->Asn substitution", 0.958863, 0.945000);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 590: {
      Modification mod("Xle->Lys", "Leu/Ile->Lys substitution", 15.010899, 15.014600);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 594: {
      Modification mod("Lys->Thr", "Lys->Thr substitution", -27.047285, -27.068400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 595: {
      Modification mod("Lys->Asn", "Lys->Asn substitution", -14.052036, -14.069600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 596: {
      Modification mod("Lys->Glu", "Lys->Glu substitution", 0.947630, 0.941700);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 597: {
      Modification mod("Lys->Gln", "Lys->Gln substitution", -0.036386, -0.043100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 598: {
      Modification mod("Lys->Met", "Lys->Met substitution", 2.945522, 3.023800);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 599: {
      Modification mod("Lys->Arg", "Lys->Arg substitution", 28.006148, 28.013400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 600: {
      Modification mod("Lys->Xle", "Lys->Leu/Ile substitution", -15.010899, -15.014600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 601: {
      Modification mod("Xle->Ser", "Leu/Ile->Ser substitution", -26.052036, -26.080300);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 602: {
      Modification mod("Xle->Phe", "Leu/Ile->Phe substitution", 33.984350, 34.016200);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 603: {
      Modification mod("Xle->Trp", "Leu/Ile->Trp substitution", 72.995249, 73.052300);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 604: {
      Modification mod("Xle->Pro", "Leu/Ile->Pro substitution", -16.031300, -16.042500);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 605: {
      Modification mod("Xle->Val", "Leu/Ile->Val substitution", -14.015650, -14.026600);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 606: {
      Modification mod("Xle->His", "Leu/Ile->His substitution", 23.974848, 23.981600);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 607: {
      Modification mod("Xle->Gln", "Leu/Ile->Gln substitution", 14.974514, 14.971600);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 608: {
      Modification mod("Xle->Met", "Leu/Ile->Met substitution", 17.956421, 18.038400);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 609: {
      Modification mod("Xle->Arg", "Leu/Ile->Arg substitution", 43.017047, 43.028000);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 610: {
      Modification mod("Met->Thr", "Met->Thr substitution", -29.992806, -30.092200);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 611: {
      Modification mod("Met->Arg", "Met->Arg substitution", 25.060626, 24.989600);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 613: {
      Modification mod("Met->Lys", "Met->Lys substitution", -2.945522, -3.023800);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 614: {
      Modification mod("Met->Xle", "Met->Leu/Ile substitution", -17.956421, -18.038400);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 615: {
      Modification mod("Met->Val", "Met->Val substitution", -31.972071, -32.065000);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 616: {
      Modification mod("Asn->Ser", "Asn->Ser substitution", -27.010899, -27.025300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 617: {
      Modification mod("Asn->Thr", "Asn->Thr substitution", -12.995249, -12.998800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 618: {
      Modification mod("Asn->Lys", "Asn->Lys substitution", 14.052036, 14.069600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 619: {
      Modification mod("Asn->Tyr", "Asn->Tyr substitution", 49.020401, 49.070600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 620: {
      Modification mod("Asn->His", "Asn->His substitution", 23.015984, 23.036600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 621: {
      Modification mod("Asn->Asp", "Asn->Asp substitution", 0.984016, 0.984800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 622: {
      Modification mod("Asn->Xle", "Asn->Leu/Ile substitution", -0.958863, -0.945000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 623: {
      Modification mod("Pro->Ser", "Pro->Ser substitution", -10.020735, -10.037900);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 624: {
      Modification mod("Pro->Ala", "Pro->Ala substitution", -26.015650, -26.037300);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 625: {
      Modification mod("Pro->His", "Pro->His substitution", 40.006148, 40.024100);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 626: {
      Modification mod("Pro->Gln", "Pro->Gln substitution", 31.005814, 31.014000);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 627: {
      Modification mod("Pro->Thr", "Pro->Thr substitution", 3.994915, 3.988700);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 628: {
      Modification mod("Pro->Arg", "Pro->Arg substitution", 59.048347, 59.070500);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 629: {
      Modification mod("Pro->Xle", "Pro->Leu/Ile substitution", 16.031300, 16.042500);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 630: {
      Modification mod("Gln->Pro", "Gln->Pro substitution", -31.005814, -31.014000);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 631: {
      Modification mod("Gln->Lys", "Gln->Lys substitution", 0.036386, 0.043100);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 632: {
      Modification mod("Gln->Glu", "Gln->Glu substitution", 0.984016, 0.984800);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 633: {
      Modification mod("Gln->His", "Gln->His substitution", 9.000334, 9.010100);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 634: {
      Modification mod("Gln->Arg", "Gln->Arg substitution", 28.042534, 28.056500);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 635: {
      Modification mod("Gln->Xle", "Gln->Leu/Ile substitution", -14.974514, -14.971600);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 636: {
      Modification mod("Arg->Ser", "Arg->Ser substitution", -69.069083, -69.108400);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 637: {
      Modification mod("Arg->Trp", "Arg->Trp substitution", 29.978202, 30.024200);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 638: {
      Modification mod("Arg->Thr", "Arg->Thr substitution", -55.053433, -55.081800);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 639: {
      Modification mod("Arg->Pro", "Arg->Pro substitution", -59.048347, -59.070500);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 640: {
      Modification mod("Arg->Lys", "Arg->Lys substitution", -28.006148, -28.013400);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 641: {
      Modification mod("Arg->His", "Arg->His substitution", -19.042199, -19.046400);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 642: {
      Modification mod("Arg->Gln", "Arg->Gln substitution", -28.042534, -28.056500);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 643: {
      Modification mod("Arg->Met", "Arg->Met substitution", -25.060626, -24.989600);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 644: {
      Modification mod("Arg->Cys", "Arg->Cys substitution", -53.091927, -53.042800);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 645: {
      Modification mod("Arg->Xle", "Arg->Leu/Ile substitution", -43.017047, -43.028000);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 646: {
      Modification mod("Arg->Gly", "Arg->Gly substitution", -99.079647, -99.134400);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 647: {
      Modification mod("Ser->Phe", "Ser->Phe substitution", 60.036386, 60.096600);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 648: {
      Modification mod("Ser->Ala", "Ser->Ala substitution", -15.994915, -15.999400);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 649: {
      Modification mod("Ser->Trp", "Ser->Trp substitution", 99.047285, 99.132600);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 650: {
      Modification mod("Ser->Thr", "Ser->Thr substitution", 14.015650, 14.026600);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 651: {
      Modification mod("Ser->Asn", "Ser->Asn substitution", 27.010899, 27.025300);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 652: {
      Modification mod("Ser->Pro", "Ser->Pro substitution", 10.020735, 10.037900);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 653: {
      Modification mod("Ser->Tyr", "Ser->Tyr substitution", 76.031300, 76.096000);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 654: {
      Modification mod("Ser->Cys", "Ser->Cys substitution", 15.977156, 16.065600);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 655: {
      Modification mod("Ser->Arg", "Ser->Arg substitution", 69.069083, 69.108400);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 656: {
      Modification mod("Ser->Xle", "Ser->Leu/Ile substitution", 26.052036, 26.080300);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 657: {
      Modification mod("Ser->Gly", "Ser->Gly substitution", -30.010565, -30.026000);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 658: {
      Modification mod("Thr->Ser", "Thr->Ser substitution", -14.015650, -14.026600);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 659: {
      Modification mod("Thr->Ala", "Thr->Ala substitution", -30.010565, -30.026000);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 660: {
      Modification mod("Thr->Asn", "Thr->Asn substitution", 12.995249, 12.998800);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 661: {
      Modification mod("Thr->Lys", "Thr->Lys substitution", 27.047285, 27.068400);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 662: {
      Modification mod("Thr->Pro", "Thr->Pro substitution", -3.994915, -3.988700);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 663: {
      Modification mod("Thr->Met", "Thr->Met substitution", 29.992806, 30.092200);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 664: {
      Modification mod("Thr->Xle", "Thr->Leu/Ile substitution", 12.036386, 12.053800);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 665: {
      Modification mod("Thr->Arg", "Thr->Arg substitution", 55.053433, 55.081800);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 666: {
      Modification mod("Val->Phe", "Val->Phe substitution", 48.000000, 48.042800);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 667: {
      Modification mod("Val->Ala", "Val->Ala substitution", -28.031300, -28.053200);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 668: {
      Modification mod("Val->Glu", "Val->Glu substitution", 29.974179, 29.982900);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 669: {
      Modification mod("Val->Met", "Val->Met substitution", 31.972071, 32.065000);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 670: {
      Modification mod("Val->Asp", "Val->Asp substitution", 15.958529, 15.956300);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 671: {
      Modification mod("Val->Xle", "Val->Leu/Ile substitution", 14.015650, 14.026600);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 672: {
      Modification mod("Val->Gly", "Val->Gly substitution", -42.046950, -42.079700);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 673: {
      Modification mod("Trp->Ser", "Trp->Ser substitution", -99.047285, -99.132600);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 674: {
      Modification mod("Trp->Cys", "Trp->Cys substitution", -83.070128, -83.067000);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 675: {
      Modification mod("Trp->Arg", "Trp->Arg substitution", -29.978202, -30.024200);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 676: {
      Modification mod("Trp->Gly", "Trp->Gly substitution", -129.057849, -129.158600);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 677: {
      Modification mod("Trp->Xle", "Trp->Leu/Ile substitution", -72.995249, -73.052300);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 678: {
      Modification mod("Tyr->Phe", "Tyr->Phe substitution", -15.994915, -15.999400);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 679: {
      Modification mod("Tyr->Ser", "Tyr->Ser substitution", -76.031300, -76.096000);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 680: {
      Modification mod("Tyr->Asn", "Tyr->Asn substitution", -49.020401, -49.070600);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 681: {
      Modification mod("Tyr->His", "Tyr->His substitution", -26.004417, -26.034000);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 682: {
      Modification mod("Tyr->Asp", "Tyr->Asp substitution", -48.036386, -48.085900);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 683: {
      Modification mod("Tyr->Cys", "Tyr->Cys substitution", -60.054144, -60.030400);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 684: {
      Modification mod("BDMAPP", "Mass Defect Tag on lysine e-amino", 253.010225, 254.123100);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 685: {
      Modification mod("NA-LNO2", "Nitroalkylation by Nitro Linoleic Acid", 325.225309, 325.443000);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 686: {
      Modification mod("NA-OA-NO2", "Nitroalkylation by Nitro Oleic Acid", 327.240959, 327.458900);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 687: {
      Modification mod("ICPL:2H(4)", "Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, medium form", 109.046571, 109.118800);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 894: {
      Modification mod("CarboxymethylDTT", "Carboxymethylated DTT modification of cysteine", 210.002050, 210.271200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 730: {
      Modification mod("iTRAQ8plex", "Representative mass and accurate mass for 113, 114, 116 & 117", 304.205360, 304.307400);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 695: {
      Modification mod("Label:13C(6)15N(1)", "13C(6) 15N(1) Silac label", 7.017164, 6.949300);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 696: {
      Modification mod("Label:2H(9)13C(6)15N(2)", "13C(6) 15N(2) (D)9 SILAC label", 17.070690, 16.998200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 720: {
      Modification mod("HNE-Delta:H(2)O", "Dehydrated 4-hydroxynonenal", 138.104465, 138.206900);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 721: {
      Modification mod("4-ONE", "4-Oxononenal (ONE)", 154.099380, 154.206300);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 723: {
      Modification mod("O-Dimethylphosphate", "O-Dimethylphosphorylation", 107.997631, 108.033100);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 724: {
      Modification mod("O-Methylphosphate", "O-Methylphosphorylation", 93.981981, 94.006500);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 725: {
      Modification mod("Diethylphosphate", "O-Diethylphosphorylation", 136.028931, 136.086200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 726: {
      Modification mod("Ethylphosphate", "O-Ethylphosphorylation", 107.997631, 108.033100);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 727: {
      Modification mod("O-pinacolylmethylphosphonate", "O-pinacolylmethylphosphonylation", 162.080967, 162.166600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 728: {
      Modification mod("Methylphosphonate", "Methylphosphonylation", 77.987066, 78.007100);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 729: {
      Modification mod("O-Isopropylmethylphosphonate", "O-Isopropylmethylphosphonylation", 120.034017, 120.086800);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 731: {
      Modification mod("iTRAQ8plex:13C(6)15N(2)", "Accurate mass for 115, 118, 119 & 121", 304.199040, 304.308100);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 735: {
      Modification mod("BEMAD_ST", "Beta elimination of modified S or T followed by Michael addition of DTT", 136.001656, 136.235700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 734: {
      Modification mod("Ethanolamine", "Carboxyl modification with ethanolamine", 43.042199, 43.067800);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 737: {
      Modification mod("TMT6plex", "Sixplex Tandem Mass Tag", 229.162932, 229.263400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 736: {
      Modification mod("BEMAD_C", "Beta elimination of alkylated Cys followed by Michael addition of DTT", 120.024500, 120.170100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 738: {
      Modification mod("TMT2plex", "Duplex Tandem Mass Tag", 225.155833, 225.292100);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 739: {
      Modification mod("TMT", "Native Tandem Mass Tag", 224.152478, 224.299400);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 740: {
      Modification mod("ExacTagThiol", "ExacTag Thiol label mass for 2-4-7-10 plex", 972.365219, 972.726800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 741: {
      Modification mod("ExacTagAmine", "ExacTag Amine label mass for 2-4-7-10 plex", 1046.347854, 1046.828500);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 744: {
      Modification mod("NO_SMX_SEMD", "Nitroso Sulfamethoxazole Sulphenamide thiol adduct", 251.036462, 251.261800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 743: {
      Modification mod("4-ONE+Delta:H(-2)O(-1)", "Dehydrated 4-Oxononenal Michael adduct", 136.088815, 136.191000);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2052: {
      Modification mod("Biotin:Aha-DADPS", "Intact DADPS Biotin Alkyne tag", 922.465403, 923.202200);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 746: {
      Modification mod("NO_SMX_SIMD", "Nitroso Sulfamethoxazole Sulfinamide thiol adduct", 267.031377, 267.261200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 747: {
      Modification mod("Malonyl", "Malonylation", 86.000394, 86.046200);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 748: {
      Modification mod("3sulfo", "derivatization by N-term modification using 3-Sulfobenzoic succinimidyl ester", 183.983029, 184.169300);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 750: {
      Modification mod("trifluoro", "trifluoroleucine replacement of leucine", 53.971735, 53.971400);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 751: {
      Modification mod("TNBS", "tri nitro benzene", 210.986535, 211.088600);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 774: {
      Modification mod("Biotin-phenacyl", "Alkylation by biotinylated form of phenacyl bromide", 626.263502, 626.727000);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 764: {
      Modification mod("BEMAD_C:2H(6)", "Beta elimination of alkylated Cys followed by Michael addition of labelled DTT", 126.062161, 126.207100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 771: {
      Modification mod("lapachenole", "lapachenole photochemically added to cysteine", 240.115030, 240.297000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 772: {
      Modification mod("Label:13C(5)", "13C(5) Silac label", 5.016774, 4.963300);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 773: {
      Modification mod("maleimide", "maleimide", 97.016378, 97.072100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 762: {
      Modification mod("IDEnT", "Isotope Distribution Encoded Tag", 214.990469, 216.064000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 763: {
      Modification mod("BEMAD_ST:2H(6)", "Beta elimination of modified S or T followed by Michael addition of labelled DTT", 142.039317, 142.272700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 765: {
      Modification mod("Met-loss", "Removal of initiator methionine from protein N-terminus", -131.040485, -131.196100);
      mod.addSpecificity('M', PROTEIN_N);
      return mod;
    }
    case 766: {
      Modification mod("Met-loss+Acetyl", "Removal of initiator methionine from protein N-terminus, then acetylation of the new N-terminus", -89.029920, -89.159400);
      mod.addSpecificity('M', PROTEIN_N);
      return mod;
    }
    case 767: {
      Modification mod("Menadione-HQ", "Menadione hydroquinone derivative", 172.052430, 172.180000);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 775: {
      Modification mod("Carboxymethyl:13C(2)", "Iodoacetic acid derivative w/ 13C label", 60.012189, 60.021400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 776: {
      Modification mod("NEM:2H(5)", "D5 N-ethylmaleimide on cysteines", 130.079062, 130.156100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 822: {
      Modification mod("Gly-loss+Amide", "Enzymatic glycine removal leaving an amidated C-terminus", -58.005479, -58.036100);
      mod.addSpecificity('G', ANY_C);
      return mod;
    }
    case 827: {
      Modification mod("TMPP-Ac", "tris(2,4,6-trimethoxyphenyl)phosphonium acetic acid N-hydroxysuccinimide ester derivative", 572.181134, 572.540100);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 799: {
      Modification mod("Label:13C(6)+GG", "13C6 labeled ubiquitinylation residue", 120.063056, 120.058600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 837: {
      Modification mod("Arg->Npo", "Arginine replacement by Nitropyrimidyl ornithine", 80.985078, 81.029700);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 834: {
      Modification mod("Label:2H(4)+Acetyl", "Acetyl 4,4,5,5-D4 Lysine", 46.035672, 46.061300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 801: {
      Modification mod("Pentylamine", "Labeling transglutaminase substrate on glutamine side chain", 70.078250, 70.132900);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 800: {
      Modification mod("Biotin:Thermo-21345", "was PentylamineBiotin", 311.166748, 311.442900);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 830: {
      Modification mod("Dihydroxyimidazolidine", "Dihydroxy methylglyoxal adduct", 72.021129, 72.062700);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 825: {
      Modification mod("Xlink:DFDNB", "Intact DFDNB crosslinker", 163.985807, 164.075200);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 821: {
      Modification mod("Cy3b-maleimide", "fluorescent dye that labels cysteines", 682.246120, 682.785200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 793: {
      Modification mod("Hex(1)HexNAc(1)", "Hex1HexNAc1", 365.132196, 365.333100);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 792: {
      Modification mod("AEC-MAEC:2H(4)", "deuterium cysteamine modification to S or T", 63.044462, 63.158000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 824: {
      Modification mod("Xlink:BMOE", "Intact or monolink BMOE crosslinker", 220.048407, 220.181500);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 811: {
      Modification mod("Biotin:Thermo-21360", "was Biotin-PEO4-hydrazide", 487.246455, 487.613400);
      mod.addSpecificity('c', ANYWHERE);
      return mod;
    }
    case 835: {
      Modification mod("Label:13C(6)+Acetyl", "Acetyl 13C(6) Silac label", 48.030694, 47.992600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 836: {
      Modification mod("Label:13C(6)15N(2)+Acetyl", "Acetyl_13C(6) 15N(2) Silac label", 50.024764, 49.979400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 846: {
      Modification mod("EQIGG", "Sumo mutant Smt3-WT tail following trypsin digestion", 484.228162, 484.503500);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 849: {
      Modification mod("cGMP", "S-guanylation", 343.031785, 343.189500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 851: {
      Modification mod("cGMP+RMP-loss", "S-guanylation-2", 150.041585, 150.118200);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 888: {
      Modification mod("mTRAQ", "mTRAQ light", 140.094963, 140.183000);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 848: {
      Modification mod("Arg2PG", "Adduct of phenylglyoxal with Arg", 266.057909, 266.248200);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 853: {
      Modification mod("Label:2H(4)+GG", "Ubiquitination 2H4 lysine", 118.068034, 118.127300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1420: {
      Modification mod("spermine", "spermine adduct", 185.189198, 185.309700);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 862: {
      Modification mod("Label:13C(1)2H(3)", "SILAC", 4.022185, 4.011100);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 861: {
      Modification mod("ZGB", "NHS ester linked Green Fluorescent Bodipy Dye", 758.380841, 758.726100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 859: {
      Modification mod("MG-H1", "Methylglyoxal-derived hydroimidazolone", 54.010565, 54.047400);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 860: {
      Modification mod("G-H1", "Glyoxal-derived hydroimiadazolone", 39.994915, 40.020800);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 864: {
      Modification mod("Label:13C(6)15N(2)+GG", "13C(6) 15N(2) Lysine glygly", 122.057126, 122.045400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 866: {
      Modification mod("ICPL:13C(6)2H(4)", "Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, +10 Da form", 115.066700, 115.074700);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 890: {
      Modification mod("DyLight-maleimide", "Thiol-reactive dye for fluorescence labelling of proteins", 940.199900, 941.076200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 889: {
      Modification mod("mTRAQ:13C(3)15N(1)", "mTRAQ medium", 144.102063, 144.154400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 891: {
      Modification mod("Methyl-PEO12-Maleimide", "Methyl-PEO12-Maleimide", 710.383719, 710.807300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 887: {
      Modification mod("MDCC", "covalent linkage of maleimidyl coumarin probe (Molecular Probes D-10253)", 383.148121, 383.397800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 877: {
      Modification mod("QQQTGG", "SUMOylation by SUMO-2/3", 599.266339, 599.594200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 876: {
      Modification mod("QEQTGG", "SUMOylation by SUMO-1", 600.250354, 600.578900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 886: {
      Modification mod("HydroxymethylOP", "2-ammonio-6-[4-(hydroxymethyl)-3-oxidopyridinium-1-yl]- hexanoate", 108.021129, 108.094800);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 884: {
      Modification mod("Biotin:Thermo-21325", "was ChromoBiotin", 695.310118, 695.828800);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 885: {
      Modification mod("Label:13C(1)2H(3)+Oxidation", "Oxidised methionine 13C(1)2H(3) SILAC label", 20.017100, 20.010500);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 2050: {
      Modification mod("shTMTpro", "Super Heavy TMTpro", 313.231019, 313.247300);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 895: {
      Modification mod("Biotin-PEG-PRA", "Biotin polyethyleneoxide (n=3) alkyne", 578.317646, 578.661100);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 896: {
      Modification mod("Met->Aha", "Methionine replacement by azido homoalanine", -4.986324, -5.079400);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 897: {
      Modification mod("Label:15N(4)", "SILAC 15N(4)", 3.988140, 3.973600);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 898: {
      Modification mod("pyrophospho", "pyrophosphorylation of Ser/Thr", 159.932662, 159.959800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 899: {
      Modification mod("Met->Hpg", "methionine replacement by homopropargylglycine", -21.987721, -22.070200);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 901: {
      Modification mod("4AcAllylGal", "2,3,4,6-tetra-O-Acetyl-1-allyl-alpha-D-galactopyranoside modification of cysteine", 372.142033, 372.367100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 902: {
      Modification mod("DimethylArsino", "Reaction with dimethylarsinous (AsIII) acid", 103.960719, 103.982700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 903: {
      Modification mod("Lys->CamCys", "Lys->Cys substitution and carbamidomethylation", 31.935685, 32.021900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 904: {
      Modification mod("Phe->CamCys", "Phe->Cys substitution and carbamidomethylation", 12.962234, 13.020400);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 905: {
      Modification mod("Leu->MetOx", "Leu->Met substitution and sulfoxidation", 33.951335, 34.037800);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 906: {
      Modification mod("Lys->MetOx", "Lys->Met substitution and sulfoxidation", 18.940436, 19.023200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 907: {
      Modification mod("Galactosyl", "Gluconoylation", 178.047738, 178.140000);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 908: {
      Modification mod("Xlink:SMCC[321]", "Monolink of SMCC terminated with 3-(dimethylamino)-1-propylamine", 321.205242, 321.414600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 910: {
      Modification mod("Bacillosamine", "2,4-diacetamido-2,4,6-trideoxyglucopyranose", 228.111007, 228.245000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 911: {
      Modification mod("MTSL", "Cys modification by (1-oxyl-2,2,5,5-tetramethyl-3-pyrroline-3-methyl)methanesulfonate (MTSL)", 184.079610, 184.278600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 912: {
      Modification mod("HNE-BAHAH", "4-hydroxy-2-nonenal and biotinamidohexanoic acid hydrazide, reduced", 511.319226, 511.720900);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2039: {
      Modification mod("LTX+Lophotoxin", "addition of lophotoxin to tyrosine", 416.147118, 416.421200);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 914: {
      Modification mod("Methylmalonylation", "Methylmalonylation on Serine", 100.016044, 100.072800);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 938: {
      Modification mod("AROD", "Cysteine modifier", 820.336015, 820.979000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 939: {
      Modification mod("Cys->methylaminoAla", "carbamidomethylated Cys that undergoes beta-elimination and Michael addition of methylamine", -2.945522, -3.023800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 940: {
      Modification mod("Cys->ethylaminoAla", "Carbamidomethylated Cys that undergoes beta-elimination and Michael addition of ethylamine", 11.070128, 11.002800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 923: {
      Modification mod("Label:13C(4)15N(2)+GG", "13C(4) 15N(2) Lysine glygly", 120.050417, 120.060100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 926: {
      Modification mod("ethylamino", "ethyl amino", 27.047285, 27.068400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 928: {
      Modification mod("MercaptoEthanol", "2-OH-ethyl thio-Ser", 60.003371, 60.118200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 935: {
      Modification mod("Atto495Maleimide", "High molecular absorption maleimide label for proteins", 474.250515, 474.574700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 934: {
      Modification mod("AMTzHexNAc2", "Photocleavable Biotin + GalNAz on O-GlcNAc", 502.202341, 502.475700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 931: {
      Modification mod("Ethyl+Deamidated", "deamidation followed by esterification with ethanol", 29.015316, 29.037900);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 932: {
      Modification mod("VFQQQTGG", "SUMOylation by SUMO-2/3 (formic acid cleavage)", 845.403166, 845.899100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 933: {
      Modification mod("VIEVYQEQTGG", "SUMOylation by SUMO-1 (formic acid cleavage)", 1203.577168, 1204.285900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 936: {
      Modification mod("Chlorination", "Chlorination of tyrosine residues", 33.961028, 34.445100);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 937: {
      Modification mod("dichlorination", "Dichlorination", 67.922055, 68.890100);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 941: {
      Modification mod("DNPS", "2,4-Dinitrobenzenesulfenyl", 198.981352, 199.164000);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 942: {
      Modification mod("SulfoGMBS", "High molecular absorption label for proteins", 458.162391, 458.530600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 943: {
      Modification mod("DimethylamineGMBS", "Modified GMBS X linker", 267.158292, 267.324100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 944: {
      Modification mod("Label:15N(2)2H(9)", "SILAC label", 11.050561, 11.042300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 946: {
      Modification mod("LG-anhydrolactam", "Levuglandinyl-lysine anhydrolactam adduct", 314.188195, 314.418600);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 947: {
      Modification mod("LG-pyrrole", "Levuglandinyl-lysine pyrrole adduct", 316.203845, 316.434500);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 948: {
      Modification mod("LG-anhyropyrrole", "Levuglandinyl-lysine anhyropyrrole adduct", 298.193280, 298.419200);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 949: {
      Modification mod("3-deoxyglucosone", "Condensation product of 3-deoxyglucosone", 144.042259, 144.125300);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 950: {
      Modification mod("Cation:Li", "Replacement of proton by lithium", 6.008178, 5.933100);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 951: {
      Modification mod("Cation:Ca[II]", "Replacement of 2 protons by calcium", 37.946941, 38.062100);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 952: {
      Modification mod("Cation:Fe[II]", "Replacement of 2 protons by iron", 53.919289, 53.829100);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 953: {
      Modification mod("Cation:Ni[II]", "Replacement of 2 protons by nickel", 55.919696, 56.677500);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 954: {
      Modification mod("Cation:Zn[II]", "Replacement of 2 protons by zinc", 61.913495, 63.393100);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 955: {
      Modification mod("Cation:Ag", "Replacement of proton by silver", 105.897267, 106.860300);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 956: {
      Modification mod("Cation:Mg[II]", "Replacement of 2 protons by magnesium", 21.969392, 22.289100);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 957: {
      Modification mod("2-succinyl", "S-(2-succinyl) cysteine", 116.010959, 116.072200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 958: {
      Modification mod("Propargylamine", "propargylamine", 37.031634, 37.063200);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 959: {
      Modification mod("Phosphopropargyl", "phospho-propargylamine", 116.997965, 117.043100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 960: {
      Modification mod("SUMO2135", "SUMOylation by SUMO-1 after tryptic cleavage", 2135.920496, 2137.234300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 961: {
      Modification mod("SUMO3549", "SUMOylation by SUMO-2/3 after tryptic cleavage", 3549.536568, 3551.667200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1992: {
      Modification mod("serotonylation", "5-glutamyl serotonin", 159.068414, 159.184600);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 978: {
      Modification mod("BITC", "Benzyl isothiocyanate", 149.029920, 149.212900);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 977: {
      Modification mod("Carbofuran", "2,3-dihydro-2,2-dimethyl-7-benzofuranol N-methyl carbamate", 57.021464, 57.051300);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 979: {
      Modification mod("PEITC", "Phenethyl isothiocyanate", 163.045570, 163.239500);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 967: {
      Modification mod("thioacylPA", "membrane protein extraction", 159.035399, 159.206200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 971: {
      Modification mod("maleimide3", "maleimide-3-saccharide", 969.366232, 969.897500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 972: {
      Modification mod("maleimide5", "maleimide-5-saccharide", 1293.471879, 1294.178700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 973: {
      Modification mod("Puromycin", "Puromycin", 453.212452, 453.494300);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 981: {
      Modification mod("glucosone", "Condensation product of glucosone", 160.037173, 160.124700);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 986: {
      Modification mod("Label:13C(6)+Dimethyl", "Dimethyl 13C(6) Silac label", 34.051429, 34.009100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 984: {
      Modification mod("cysTMT", "Native cysteine-reactive Tandem Mass Tag", 299.166748, 299.432200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 985: {
      Modification mod("cysTMT6plex", "cysteine-reactive Sixplex Tandem Mass Tag", 304.177202, 304.396200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 991: {
      Modification mod("ISD_z+2_ion", "ISD (z+2)-series", -15.010899, -15.014600);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 989: {
      Modification mod("Ammonium", "replacement of proton with ammonium ion", 17.026549, 17.030500);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 993: {
      Modification mod("Biotin:Sigma-B1267", "was Biotin-maleimide", 449.173290, 449.523900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 994: {
      Modification mod("Label:15N(1)", "15N(1)", 0.997035, 0.993400);
      mod.addSpecificity('M', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('V', ANYWHERE);
      mod.addSpecificity('P', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('A', ANYWHERE);
      mod.addSpecificity('G', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 995: {
      Modification mod("Label:15N(2)", "15N(2)", 1.994070, 1.986800);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 996: {
      Modification mod("Label:15N(3)", "15N(3)", 2.991105, 2.980200);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 997: {
      Modification mod("sulfo+amino", "aminotyrosine with sulfation", 94.967714, 95.077800);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1000: {
      Modification mod("AHA-Alkyne", "Azidohomoalanine (AHA) bound to propargylglycine-NH2 (alkyne)", 107.077339, 107.050400);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1001: {
      Modification mod("AHA-Alkyne-KDDDD", "Azidohomoalanine (AHA) bound to DDDDK-propargylglycine-NH2 (alkyne)", 695.280074, 695.572300);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1002: {
      Modification mod("EGCG1", "(-)-epigallocatechin-3-gallate", 456.069261, 456.355800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1003: {
      Modification mod("EGCG2", "(-)-dehydroepigallocatechin", 287.055563, 287.244200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1004: {
      Modification mod("Label:13C(6)15N(4)+Methyl", "Monomethylated Arg13C(6) 15N(4)", 24.023919, 23.956100);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1005: {
      Modification mod("Label:13C(6)15N(4)+Dimethyl", "Dimethylated Arg13C(6) 15N(4)", 38.039569, 37.982700);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1006: {
      Modification mod("Label:13C(6)15N(4)+Methyl:2H(3)13C(1)", "2H(3) 13C(1) monomethylated Arg13C(6) 15N(4)", 28.046104, 27.967300);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1007: {
      Modification mod("Label:13C(6)15N(4)+Dimethyl:2H(6)13C(2)", "2H(6) 13C(2) Dimethylated Arg13C(6) 15N(4)", 46.083939, 46.005000);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1008: {
      Modification mod("Cys->CamSec", "Sec Iodoacetamide derivative", 104.965913, 103.946300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1009: {
      Modification mod("Thiazolidine", "formaldehyde adduct", 12.000000, 12.010700);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1010: {
      Modification mod("DEDGFLYMVYASQETFG", "Addition of DEDGFLYMVYASQETFG", 1970.824411, 1972.088000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1012: {
      Modification mod("Biotin:Invitrogen-M1602", "Nalpha-(3-maleimidylpropionyl)biocytin", 523.210069, 523.602400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1020: {
      Modification mod("Xlink:DSS[156]", "Water-quenched monolink of DSS/BS3 crosslinker", 156.078644, 156.179100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1017: {
      Modification mod("DMPO", "DMPO spin-trap nitrone adduct", 111.068414, 111.141800);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1014: {
      Modification mod("glycidamide", "glycidamide adduct", 87.032028, 87.077300);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1015: {
      Modification mod("Ahx2+Hsl", "C-terminal homoserine lactone and two aminohexanoic acids", 309.205242, 309.403900);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 1018: {
      Modification mod("ICDID", "Isotope-Coded Dimedone light form", 138.068080, 138.163800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1019: {
      Modification mod("ICDID:2H(6)", "Isotope-Coded Dimedone heavy form", 144.105740, 144.200800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1021: {
      Modification mod("Xlink:EGS[244]", "Water quenched monolink of EGS cross-linker", 244.058303, 244.198100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1022: {
      Modification mod("Xlink:DST[132]", "Water quenched monolink of DST crosslinker", 132.005873, 132.071600);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1023: {
      Modification mod("Xlink:DTSSP[192]", "Water quenched monolink of DSP/DTSSP crosslinker", 191.991486, 192.255900);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1024: {
      Modification mod("Xlink:SMCC[237]", "Water quenched monolink of SMCC", 237.100108, 237.251800);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1032: {
      Modification mod("2-nitrobenzyl", "Tyrosine caged with 2-nitrobenzyl (ONB)", 135.032028, 135.120100);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1027: {
      Modification mod("Xlink:DMP[140]", "Water quenched monolink of DMP crosslinker", 140.094963, 140.183000);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1028: {
      Modification mod("Xlink:EGS[115]", "Cleavage product of EGS protein crosslinks by hydroylamine treatment", 115.026943, 115.087400);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1033: {
      Modification mod("Cys->SecNEM", "N-ethylmaleimide on selenocysteines", 172.992127, 172.020300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1034: {
      Modification mod("Cys->SecNEM:2H(5)", "D5 N-ethylmaleimide on selenocysteines", 178.023511, 177.051100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1035: {
      Modification mod("Thiadiazole", "Thiadiazolydation of Cys", 174.025169, 174.222300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1031: {
      Modification mod("Biotin:Thermo-88310", "desthiobiotin modification of lysine", 196.121178, 196.246200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1038: {
      Modification mod("TAMRA-FP", "TAMRA fluorophosphonate modification of serine", 659.312423, 659.751400);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1039: {
      Modification mod("Biotin:Thermo-21901+H2O", "Maleimide-Biotin + Water", 543.236284, 543.633600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1041: {
      Modification mod("Deoxyhypusine", "Deoxyhypusine", 71.073499, 71.121000);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1042: {
      Modification mod("Acetyldeoxyhypusine", "Acetyldeoxyhypusine", 113.084064, 113.157600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1043: {
      Modification mod("Acetylhypusine", "Acetylhypusine", 129.078979, 129.157000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1044: {
      Modification mod("Ala->Cys", "Ala->Cys substitution", 31.972071, 32.065000);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1045: {
      Modification mod("Ala->Phe", "Ala->Phe substitution", 76.031300, 76.096000);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1046: {
      Modification mod("Ala->His", "Ala->His substitution", 66.021798, 66.061400);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1047: {
      Modification mod("Ala->Xle", "Ala->Leu/Ile substitution", 42.046950, 42.079700);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1048: {
      Modification mod("Ala->Lys", "Ala->Lys substitution", 57.057849, 57.094400);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1049: {
      Modification mod("Ala->Met", "Ala->Met substitution", 60.003371, 60.118200);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1050: {
      Modification mod("Ala->Asn", "Ala->Asn substitution", 43.005814, 43.024700);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1051: {
      Modification mod("Ala->Gln", "Ala->Gln substitution", 57.021464, 57.051300);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1052: {
      Modification mod("Ala->Arg", "Ala->Arg substitution", 85.063997, 85.107800);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1053: {
      Modification mod("Ala->Trp", "Ala->Trp substitution", 115.042199, 115.132000);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1054: {
      Modification mod("Ala->Tyr", "Ala->Tyr substitution", 92.026215, 92.095400);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1055: {
      Modification mod("Cys->Ala", "Cys->Ala substitution", -31.972071, -32.065000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1056: {
      Modification mod("Cys->Asp", "Cys->Asp substitution", 12.017759, 11.944500);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1057: {
      Modification mod("Cys->Glu", "Cys->Glu substitution", 26.033409, 25.971100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1058: {
      Modification mod("Cys->His", "Cys->His substitution", 34.049727, 33.996400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1059: {
      Modification mod("Cys->Xle", "Cys->Leu/Ile substitution", 10.074880, 10.014700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1060: {
      Modification mod("Cys->Lys", "Cys->Lys substitution", 25.085779, 25.029400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1061: {
      Modification mod("Cys->Met", "Cys->Met substitution", 28.031300, 28.053200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1062: {
      Modification mod("Cys->Asn", "Cys->Asn substitution", 11.033743, 10.959700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1063: {
      Modification mod("Cys->Pro", "Cys->Pro substitution", -5.956421, -6.027700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1064: {
      Modification mod("Cys->Gln", "Cys->Gln substitution", 25.049393, 24.986300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1065: {
      Modification mod("Cys->Thr", "Cys->Thr substitution", -1.961506, -2.039000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1066: {
      Modification mod("Cys->Val", "Cys->Val substitution", -3.940771, -4.011800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1067: {
      Modification mod("Asp->Cys", "Asp->Cys substitution", -12.017759, -11.944500);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1068: {
      Modification mod("Asp->Phe", "Asp->Phe substitution", 32.041471, 32.086500);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1069: {
      Modification mod("Asp->Xle", "Asp->Leu/Ile substitution", -1.942879, -1.929800);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1070: {
      Modification mod("Asp->Lys", "Asp->Lys substitution", 13.068020, 13.084900);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1071: {
      Modification mod("Asp->Met", "Asp->Met substitution", 16.013542, 16.108700);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1072: {
      Modification mod("Asp->Pro", "Asp->Pro substitution", -17.974179, -17.972200);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1073: {
      Modification mod("Asp->Gln", "Asp->Gln substitution", 13.031634, 13.041800);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1074: {
      Modification mod("Asp->Arg", "Asp->Arg substitution", 41.074168, 41.098300);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1075: {
      Modification mod("Asp->Ser", "Asp->Ser substitution", -27.994915, -28.010100);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1076: {
      Modification mod("Asp->Thr", "Asp->Thr substitution", -13.979265, -13.983500);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1077: {
      Modification mod("Asp->Trp", "Asp->Trp substitution", 71.052370, 71.122500);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1078: {
      Modification mod("Glu->Cys", "Glu->Cys substitution", -26.033409, -25.971100);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1079: {
      Modification mod("Glu->Phe", "Glu->Phe substitution", 18.025821, 18.059900);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1080: {
      Modification mod("Glu->His", "Glu->His substitution", 8.016319, 8.025300);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1081: {
      Modification mod("Glu->Xle", "Glu->Leu/Ile substitution", -15.958529, -15.956300);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1082: {
      Modification mod("Glu->Met", "Glu->Met substitution", 1.997892, 2.082100);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1083: {
      Modification mod("Glu->Asn", "Glu->Asn substitution", -14.999666, -15.011300);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1084: {
      Modification mod("Glu->Pro", "Glu->Pro substitution", -31.989829, -31.998800);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1085: {
      Modification mod("Glu->Arg", "Glu->Arg substitution", 27.058518, 27.071700);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1086: {
      Modification mod("Glu->Ser", "Glu->Ser substitution", -42.010565, -42.036700);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1087: {
      Modification mod("Glu->Thr", "Glu->Thr substitution", -27.994915, -28.010100);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1088: {
      Modification mod("Glu->Trp", "Glu->Trp substitution", 57.036720, 57.095900);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1089: {
      Modification mod("Glu->Tyr", "Glu->Tyr substitution", 34.020735, 34.059300);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1090: {
      Modification mod("Phe->Ala", "Phe->Ala substitution", -76.031300, -76.096000);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1091: {
      Modification mod("Phe->Asp", "Phe->Asp substitution", -32.041471, -32.086500);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1092: {
      Modification mod("Phe->Glu", "Phe->Glu substitution", -18.025821, -18.059900);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1093: {
      Modification mod("Phe->Gly", "Phe->Gly substitution", -90.046950, -90.122500);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1094: {
      Modification mod("Phe->His", "Phe->His substitution", -10.009502, -10.034600);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1095: {
      Modification mod("Phe->Lys", "Phe->Lys substitution", -18.973451, -19.001600);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1096: {
      Modification mod("Phe->Met", "Phe->Met substitution", -16.027929, -15.977800);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1097: {
      Modification mod("Phe->Asn", "Phe->Asn substitution", -33.025486, -33.071200);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1098: {
      Modification mod("Phe->Pro", "Phe->Pro substitution", -50.015650, -50.058700);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1099: {
      Modification mod("Phe->Gln", "Phe->Gln substitution", -19.009836, -19.044600);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1100: {
      Modification mod("Phe->Arg", "Phe->Arg substitution", 9.032697, 9.011800);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1101: {
      Modification mod("Phe->Thr", "Phe->Thr substitution", -46.020735, -46.070000);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1102: {
      Modification mod("Phe->Trp", "Phe->Trp substitution", 39.010899, 39.036000);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1103: {
      Modification mod("Gly->Phe", "Gly->Phe substitution", 90.046950, 90.122500);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1104: {
      Modification mod("Gly->His", "Gly->His substitution", 80.037448, 80.088000);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1105: {
      Modification mod("Gly->Xle", "Gly->Leu/Ile substitution", 56.062600, 56.106300);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1106: {
      Modification mod("Gly->Lys", "Gly->Lys substitution", 71.073499, 71.121000);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1107: {
      Modification mod("Gly->Met", "Gly->Met substitution", 74.019021, 74.144700);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1108: {
      Modification mod("Gly->Asn", "Gly->Asn substitution", 57.021464, 57.051300);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1109: {
      Modification mod("Gly->Pro", "Gly->Pro substitution", 40.031300, 40.063900);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1110: {
      Modification mod("Gly->Gln", "Gly->Gln substitution", 71.037114, 71.077900);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1111: {
      Modification mod("Gly->Thr", "Gly->Thr substitution", 44.026215, 44.052600);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1112: {
      Modification mod("Gly->Tyr", "Gly->Tyr substitution", 106.041865, 106.121900);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
    case 1113: {
      Modification mod("His->Ala", "His->Ala substitution", -66.021798, -66.061400);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1114: {
      Modification mod("His->Cys", "His->Cys substitution", -34.049727, -33.996400);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1115: {
      Modification mod("His->Glu", "His->Glu substitution", -8.016319, -8.025300);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1116: {
      Modification mod("His->Phe", "His->Phe substitution", 10.009502, 10.034600);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1117: {
      Modification mod("His->Gly", "His->Gly substitution", -80.037448, -80.088000);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1119: {
      Modification mod("His->Lys", "His->Lys substitution", -8.963949, -8.967000);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1120: {
      Modification mod("His->Met", "His->Met substitution", -6.018427, -5.943200);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1121: {
      Modification mod("His->Ser", "His->Ser substitution", -50.026883, -50.062000);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1122: {
      Modification mod("His->Thr", "His->Thr substitution", -36.011233, -36.035400);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1123: {
      Modification mod("His->Val", "His->Val substitution", -37.990498, -38.008200);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1124: {
      Modification mod("His->Trp", "His->Trp substitution", 49.020401, 49.070600);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1126: {
      Modification mod("Xle->Cys", "Leu/Ile->Cys substitution", -10.074880, -10.014700);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 1127: {
      Modification mod("Xle->Asp", "Leu/Ile->Asp substitution", 1.942879, 1.929800);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 1128: {
      Modification mod("Xle->Glu", "Leu/Ile->Glu substitution", 15.958529, 15.956300);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 1129: {
      Modification mod("Xle->Gly", "Leu/Ile->Gly substitution", -56.062600, -56.106300);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 1130: {
      Modification mod("Xle->Tyr", "Leu/Ile->Tyr substitution", 49.979265, 50.015600);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      return mod;
    }
    case 1131: {
      Modification mod("Lys->Ala", "Lys->Ala substitution", -57.057849, -57.094400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1132: {
      Modification mod("Lys->Cys", "Lys->Cys substitution", -25.085779, -25.029400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1133: {
      Modification mod("Lys->Asp", "Lys->Asp substitution", -13.068020, -13.084900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1134: {
      Modification mod("Lys->Phe", "Lys->Phe substitution", 18.973451, 19.001600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1135: {
      Modification mod("Lys->Gly", "Lys->Gly substitution", -71.073499, -71.121000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1136: {
      Modification mod("Lys->His", "Lys->His substitution", 8.963949, 8.967000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1137: {
      Modification mod("Lys->Pro", "Lys->Pro substitution", -31.042199, -31.057100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1138: {
      Modification mod("Lys->Ser", "Lys->Ser substitution", -41.062935, -41.095000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1139: {
      Modification mod("Lys->Val", "Lys->Val substitution", -29.026549, -29.041200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1140: {
      Modification mod("Lys->Trp", "Lys->Trp substitution", 57.984350, 58.037600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1141: {
      Modification mod("Lys->Tyr", "Lys->Tyr substitution", 34.968366, 35.001000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1142: {
      Modification mod("Met->Ala", "Met->Ala substitution", -60.003371, -60.118200);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1143: {
      Modification mod("Met->Cys", "Met->Cys substitution", -28.031300, -28.053200);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1144: {
      Modification mod("Met->Asp", "Met->Asp substitution", -16.013542, -16.108700);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1145: {
      Modification mod("Met->Glu", "Met->Glu substitution", -1.997892, -2.082100);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1146: {
      Modification mod("Met->Phe", "Met->Phe substitution", 16.027929, 15.977800);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1147: {
      Modification mod("Met->Gly", "Met->Gly substitution", -74.019021, -74.144700);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1148: {
      Modification mod("Met->His", "Met->His substitution", 6.018427, 5.943200);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1149: {
      Modification mod("Met->Asn", "Met->Asn substitution", -16.997557, -17.093400);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1150: {
      Modification mod("Met->Pro", "Met->Pro substitution", -33.987721, -34.080900);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1151: {
      Modification mod("Met->Gln", "Met->Gln substitution", -2.981907, -3.066800);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1152: {
      Modification mod("Met->Ser", "Met->Ser substitution", -44.008456, -44.118800);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1153: {
      Modification mod("Met->Trp", "Met->Trp substitution", 55.038828, 55.013800);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1154: {
      Modification mod("Met->Tyr", "Met->Tyr substitution", 32.022844, 31.977200);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1155: {
      Modification mod("Asn->Ala", "Asn->Ala substitution", -43.005814, -43.024700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1156: {
      Modification mod("Asn->Cys", "Asn->Cys substitution", -11.033743, -10.959700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1157: {
      Modification mod("Asn->Glu", "Asn->Glu substitution", 14.999666, 15.011300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1158: {
      Modification mod("Asn->Phe", "Asn->Phe substitution", 33.025486, 33.071200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1159: {
      Modification mod("Asn->Gly", "Asn->Gly substitution", -57.021464, -57.051300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1160: {
      Modification mod("Asn->Met", "Asn->Met substitution", 16.997557, 17.093400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1161: {
      Modification mod("Asn->Pro", "Asn->Pro substitution", -16.990164, -16.987500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1162: {
      Modification mod("Asn->Gln", "Asn->Gln substitution", 14.015650, 14.026600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1163: {
      Modification mod("Asn->Arg", "Asn->Arg substitution", 42.058184, 42.083000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1164: {
      Modification mod("Asn->Val", "Asn->Val substitution", -14.974514, -14.971600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1165: {
      Modification mod("Asn->Trp", "Asn->Trp substitution", 72.036386, 72.107300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1166: {
      Modification mod("Pro->Cys", "Pro->Cys substitution", 5.956421, 6.027700);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1167: {
      Modification mod("Pro->Asp", "Pro->Asp substitution", 17.974179, 17.972200);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1168: {
      Modification mod("Pro->Glu", "Pro->Glu substitution", 31.989829, 31.998800);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1169: {
      Modification mod("Pro->Phe", "Pro->Phe substitution", 50.015650, 50.058700);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1170: {
      Modification mod("Pro->Gly", "Pro->Gly substitution", -40.031300, -40.063900);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1171: {
      Modification mod("Pro->Lys", "Pro->Lys substitution", 31.042199, 31.057100);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1172: {
      Modification mod("Pro->Met", "Pro->Met substitution", 33.987721, 34.080900);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1173: {
      Modification mod("Pro->Asn", "Pro->Asn substitution", 16.990164, 16.987500);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1174: {
      Modification mod("Pro->Val", "Pro->Val substitution", 2.015650, 2.015900);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1175: {
      Modification mod("Pro->Trp", "Pro->Trp substitution", 89.026549, 89.094700);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1176: {
      Modification mod("Pro->Tyr", "Pro->Tyr substitution", 66.010565, 66.058100);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1177: {
      Modification mod("Gln->Ala", "Gln->Ala substitution", -57.021464, -57.051300);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1178: {
      Modification mod("Gln->Cys", "Gln->Cys substitution", -25.049393, -24.986300);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1179: {
      Modification mod("Gln->Asp", "Gln->Asp substitution", -13.031634, -13.041800);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1180: {
      Modification mod("Gln->Phe", "Gln->Phe substitution", 19.009836, 19.044600);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1181: {
      Modification mod("Gln->Gly", "Gln->Gly substitution", -71.037114, -71.077900);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1182: {
      Modification mod("Gln->Met", "Gln->Met substitution", 2.981907, 3.066800);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1183: {
      Modification mod("Gln->Asn", "Gln->Asn substitution", -14.015650, -14.026600);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1184: {
      Modification mod("Gln->Ser", "Gln->Ser substitution", -41.026549, -41.051900);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1185: {
      Modification mod("Gln->Thr", "Gln->Thr substitution", -27.010899, -27.025300);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1186: {
      Modification mod("Gln->Val", "Gln->Val substitution", -28.990164, -28.998200);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1187: {
      Modification mod("Gln->Trp", "Gln->Trp substitution", 58.020735, 58.080700);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1188: {
      Modification mod("Gln->Tyr", "Gln->Tyr substitution", 35.004751, 35.044000);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1189: {
      Modification mod("Arg->Ala", "Arg->Ala substitution", -85.063997, -85.107800);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1190: {
      Modification mod("Arg->Asp", "Arg->Asp substitution", -41.074168, -41.098300);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1191: {
      Modification mod("Arg->Glu", "Arg->Glu substitution", -27.058518, -27.071700);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1192: {
      Modification mod("Arg->Asn", "Arg->Asn substitution", -42.058184, -42.083000);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1193: {
      Modification mod("Arg->Val", "Arg->Val substitution", -57.032697, -57.054600);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1194: {
      Modification mod("Arg->Tyr", "Arg->Tyr substitution", 6.962218, 6.987600);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1195: {
      Modification mod("Arg->Phe", "Arg->Phe substitution", -9.032697, -9.011800);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1196: {
      Modification mod("Ser->Asp", "Ser->Asp substitution", 27.994915, 28.010100);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1197: {
      Modification mod("Ser->Glu", "Ser->Glu substitution", 42.010565, 42.036700);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1198: {
      Modification mod("Ser->His", "Ser->His substitution", 50.026883, 50.062000);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1199: {
      Modification mod("Ser->Lys", "Ser->Lys substitution", 41.062935, 41.095000);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1200: {
      Modification mod("Ser->Met", "Ser->Met substitution", 44.008456, 44.118800);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1201: {
      Modification mod("Ser->Gln", "Ser->Gln substitution", 41.026549, 41.051900);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1202: {
      Modification mod("Ser->Val", "Ser->Val substitution", 12.036386, 12.053800);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1203: {
      Modification mod("Thr->Cys", "Thr->Cys substitution", 1.961506, 2.039000);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1204: {
      Modification mod("Thr->Asp", "Thr->Asp substitution", 13.979265, 13.983500);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1205: {
      Modification mod("Thr->Glu", "Thr->Glu substitution", 27.994915, 28.010100);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1206: {
      Modification mod("Thr->Phe", "Thr->Phe substitution", 46.020735, 46.070000);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1207: {
      Modification mod("Thr->Gly", "Thr->Gly substitution", -44.026215, -44.052600);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1208: {
      Modification mod("Thr->His", "Thr->His substitution", 36.011233, 36.035400);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1209: {
      Modification mod("Thr->Gln", "Thr->Gln substitution", 27.010899, 27.025300);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1210: {
      Modification mod("Thr->Val", "Thr->Val substitution", -1.979265, -1.972800);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1211: {
      Modification mod("Thr->Trp", "Thr->Trp substitution", 85.031634, 85.106000);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1212: {
      Modification mod("Thr->Tyr", "Thr->Tyr substitution", 62.015650, 62.069400);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1213: {
      Modification mod("Val->Cys", "Val->Cys substitution", 3.940771, 4.011800);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1214: {
      Modification mod("Val->His", "Val->His substitution", 37.990498, 38.008200);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1215: {
      Modification mod("Val->Lys", "Val->Lys substitution", 29.026549, 29.041200);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1216: {
      Modification mod("Val->Asn", "Val->Asn substitution", 14.974514, 14.971600);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1217: {
      Modification mod("Val->Pro", "Val->Pro substitution", -2.015650, -2.015900);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1218: {
      Modification mod("Val->Gln", "Val->Gln substitution", 28.990164, 28.998200);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1219: {
      Modification mod("Val->Arg", "Val->Arg substitution", 57.032697, 57.054600);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1220: {
      Modification mod("Val->Ser", "Val->Ser substitution", -12.036386, -12.053800);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1221: {
      Modification mod("Val->Thr", "Val->Thr substitution", 1.979265, 1.972800);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1222: {
      Modification mod("Val->Trp", "Val->Trp substitution", 87.010899, 87.078800);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1223: {
      Modification mod("Val->Tyr", "Val->Tyr substitution", 63.994915, 64.042200);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1224: {
      Modification mod("Trp->Ala", "Trp->Ala substitution", -115.042199, -115.132000);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1225: {
      Modification mod("Trp->Asp", "Trp->Asp substitution", -71.052370, -71.122500);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1226: {
      Modification mod("Trp->Glu", "Trp->Glu substitution", -57.036720, -57.095900);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1227: {
      Modification mod("Trp->Phe", "Trp->Phe substitution", -39.010899, -39.036000);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1228: {
      Modification mod("Trp->His", "Trp->His substitution", -49.020401, -49.070600);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1229: {
      Modification mod("Trp->Lys", "Trp->Lys substitution", -57.984350, -58.037600);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1230: {
      Modification mod("Trp->Met", "Trp->Met substitution", -55.038828, -55.013800);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1231: {
      Modification mod("Trp->Asn", "Trp->Asn substitution", -72.036386, -72.107300);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1232: {
      Modification mod("Trp->Pro", "Trp->Pro substitution", -89.026549, -89.094700);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1233: {
      Modification mod("Trp->Gln", "Trp->Gln substitution", -58.020735, -58.080700);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1234: {
      Modification mod("Trp->Thr", "Trp->Thr substitution", -85.031634, -85.106000);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1235: {
      Modification mod("Trp->Val", "Trp->Val substitution", -87.010899, -87.078800);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1236: {
      Modification mod("Trp->Tyr", "Trp->Tyr substitution", -23.015984, -23.036600);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1237: {
      Modification mod("Tyr->Ala", "Tyr->Ala substitution", -92.026215, -92.095400);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1238: {
      Modification mod("Tyr->Glu", "Tyr->Glu substitution", -34.020735, -34.059300);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1239: {
      Modification mod("Tyr->Gly", "Tyr->Gly substitution", -106.041865, -106.121900);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1240: {
      Modification mod("Tyr->Lys", "Tyr->Lys substitution", -34.968366, -35.001000);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1241: {
      Modification mod("Tyr->Met", "Tyr->Met substitution", -32.022844, -31.977200);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1242: {
      Modification mod("Tyr->Pro", "Tyr->Pro substitution", -66.010565, -66.058100);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1243: {
      Modification mod("Tyr->Gln", "Tyr->Gln substitution", -35.004751, -35.044000);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1244: {
      Modification mod("Tyr->Arg", "Tyr->Arg substitution", -6.962218, -6.987600);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1245: {
      Modification mod("Tyr->Thr", "Tyr->Thr substitution", -62.015650, -62.069400);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1246: {
      Modification mod("Tyr->Val", "Tyr->Val substitution", -63.994915, -64.042200);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1247: {
      Modification mod("Tyr->Trp", "Tyr->Trp substitution", 23.015984, 23.036600);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1248: {
      Modification mod("Tyr->Xle", "Tyr->Leu/Ile substitution", -49.979265, -50.015600);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1249: {
      Modification mod("AHA-SS", "Azidohomoalanine coupled to reductively cleaved tag", 195.075625, 195.178700);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1250: {
      Modification mod("AHA-SS_CAM", "carbamidomethylated form of reductively cleaved tag coupled to azidohomoalanine", 252.097088, 252.230000);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1251: {
      Modification mod("Biotin:Thermo-33033", "Sulfo-SBED Label Photoreactive Biotin Crosslinker", 548.223945, 548.721100);
      mod.addSpecificity('n', ANYWHERE);
      return mod;
    }
    case 1252: {
      Modification mod("Biotin:Thermo-33033-H", "Sulfo-SBED Label Photoreactive Biotin Crosslinker minus Hydrogen", 546.208295, 546.705300);
      mod.addSpecificity('n', ANYWHERE);
      return mod;
    }
    case 1253: {
      Modification mod("2-monomethylsuccinyl", "S-(2-monomethylsuccinyl) cysteine", 130.026609, 130.098700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1254: {
      Modification mod("Saligenin", "o-toluene", 106.041865, 106.121900);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1255: {
      Modification mod("Cresylphosphate", "o-toluyl-phosphorylation", 170.013281, 170.102400);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1256: {
      Modification mod("CresylSaligeninPhosphate", "Cresyl-Saligenin-phosphorylation", 276.055146, 276.224400);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1257: {
      Modification mod("Ub-Br2", "Ub Bromide probe addition", 100.063663, 100.119100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1258: {
      Modification mod("Ub-VME", "Ubiquitin vinylmethylester", 172.084792, 172.181800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1261: {
      Modification mod("Ub-fluorescein", "Ub Fluorescein probe addition", 597.209772, 597.598000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1262: {
      Modification mod("2-dimethylsuccinyl", "S-(2-dimethylsuccinyl) cysteine", 144.042259, 144.125300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1263: {
      Modification mod("Gly", "Addition of Glycine", 57.021464, 57.051300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1264: {
      Modification mod("pupylation", "addition of GGE", 243.085521, 243.216600);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1266: {
      Modification mod("Label:13C(4)", "13C4 Methionine label", 4.013419, 3.970600);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1271: {
      Modification mod("HCysteinyl", "S-homocysteinylation", 133.019749, 133.168900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1267: {
      Modification mod("Label:13C(4)+Oxidation", "Oxidised 13C4 labelled Methionine", 20.008334, 19.970000);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1276: {
      Modification mod("UgiJoullie", "Side reaction of HisTag", 1106.489350, 1107.127400);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1270: {
      Modification mod("HCysThiolactone", "N-Homocysteine thiolactone", 117.024835, 117.169500);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1282: {
      Modification mod("UgiJoullieProGly", "Side reaction of PG with Side chain of aspartic or glutamic acid", 154.074228, 154.166500);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1277: {
      Modification mod("Dipyridyl", "Cys modified with dipy ligand", 225.090212, 225.245900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1278: {
      Modification mod("Furan", "Chemical modification of the iodinated sites of thyroglobulin by Suzuki reaction", 66.010565, 66.058100);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1279: {
      Modification mod("Difuran", "Chemical modification of the diiodinated sites of thyroglobulin by Suzuki reaction", 132.021129, 132.116200);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1281: {
      Modification mod("BMP-piperidinol", "1-methyl-3-benzoyl-4-hydroxy-4-phenylpiperidine", 263.131014, 263.333700);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1283: {
      Modification mod("UgiJoullieProGlyProGly", "Side reaction of PGPG with Side chain of aspartic or glutamic acid", 308.148455, 308.333000);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1287: {
      Modification mod("Arg-loss", "Loss of arginine due to transpeptidation", -156.101111, -156.185700);
      mod.addSpecificity('R', ANY_C);
      return mod;
    }
    case 1288: {
      Modification mod("Arg", "Addition of arginine due to transpeptidation", 156.101111, 156.185700);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1286: {
      Modification mod("IMEHex(2)NeuAc(1)", "Glycosylation with IME linked Hex(2) NeuAc", 688.199683, 688.652700);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1289: {
      Modification mod("Butyryl", "Butyryl", 70.041865, 70.089800);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1290: {
      Modification mod("Dicarbamidomethyl", "Double Carbamidomethylation", 114.042927, 114.102600);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1291: {
      Modification mod("Dimethyl:2H(6)", "Dimethyl-Medium", 34.068961, 34.090100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1292: {
      Modification mod("GGQ", "SUMOylation leaving GlyGlyGln", 242.101505, 242.231900);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1293: {
      Modification mod("QTGG", "SUMOylation leaving GlnThrGlyGly", 343.149184, 343.335700);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1297: {
      Modification mod("Label:13C(3)15N(1)", "SILAC or AQUA label", 4.007099, 3.971400);
      mod.addSpecificity('A', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1296: {
      Modification mod("Label:13C(3)", "13C3 label for SILAC", 3.010064, 2.978000);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1298: {
      Modification mod("Label:13C(4)15N(1)", "13C4 15N1 label for SILAC", 5.010454, 4.964000);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1299: {
      Modification mod("Label:2H(10)", "2H(10) label", 10.062767, 10.061600);
      mod.addSpecificity('L', ANYWHERE);
      return mod;
    }
    case 1300: {
      Modification mod("Label:2H(4)13C(1)", "Label:2H(4)13C(1)", 5.028462, 5.017300);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1301: {
      Modification mod("Lys", "Addition of lysine due to transpeptidation", 128.094963, 128.172300);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1302: {
      Modification mod("mTRAQ:13C(6)15N(2)", "mTRAQ heavy", 148.109162, 148.125700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1303: {
      Modification mod("NeuAc", "N-acetyl neuraminic acid", 291.095417, 291.254600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1304: {
      Modification mod("NeuGc", "N-glycoyl neuraminic acid", 307.090331, 307.254000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1305: {
      Modification mod("Propyl", "Propyl", 42.046950, 42.079700);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('c', PROTEIN_C);
      return mod;
    }
    case 1306: {
      Modification mod("Propyl:2H(6)", "Propyl:2H(6)", 48.084611, 48.116700);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1310: {
      Modification mod("Propiophenone", "Propiophenone", 132.057515, 132.159200);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1345: {
      Modification mod("PS_Hapten", "reaction with phenyl salicylate (PS)", 120.021129, 120.105500);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1348: {
      Modification mod("Cy3-maleimide", "Cy3 Maleimide mono-Reactive dye", 753.262796, 753.904600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1312: {
      Modification mod("Delta:H(6)C(3)O(1)", "Reduced acrolein addition +58", 58.041865, 58.079100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1313: {
      Modification mod("Delta:H(8)C(6)O(1)", "Reduced acrolein addition +96", 96.057515, 96.127100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1314: {
      Modification mod("biotinAcrolein298", "biotin hydrazide labeled acrolein addition +298", 298.146347, 298.404400);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1315: {
      Modification mod("MM-diphenylpentanone", "3-methyl-5-(methylamino)-1,3-diphenylpentan-1-one", 265.146664, 265.349600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1317: {
      Modification mod("EHD-diphenylpentanone", "2-ethyl-3-hydroxy-1,3-diphenylpentan-1-one", 266.130680, 266.334300);
      mod.addSpecificity('M', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1349: {
      Modification mod("benzylguanidine", "modification of the lysine side chain from NH2 to guanidine with a H removed in favor of a benzyl group", 132.068748, 132.162500);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1350: {
      Modification mod("CarboxymethylDMAP", "A fixed +1 charge tag attached to the N-terminus of peptides", 162.079313, 162.188500);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1320: {
      Modification mod("Biotin:Thermo-21901+2H2O", "Maleimide-Biotin + 2Water", 561.246849, 561.648900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1321: {
      Modification mod("DiLeu4plex115", "Accurate mass for DiLeu 115 isobaric tag", 145.120000, 145.196600);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1322: {
      Modification mod("DiLeu4plex", "Accurate mass for DiLeu 116 isobaric tag", 145.132163, 145.222900);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1323: {
      Modification mod("DiLeu4plex117", "Accurate mass for DiLeu 117 isobaric tag", 145.128307, 145.209200);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1324: {
      Modification mod("DiLeu4plex118", "Accurate mass for DiLeu 118 isobaric tag", 145.140471, 145.235400);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1887: {
      Modification mod("Xlink:BuUrBu[213]", "Ammonia quenched monolink of BuUrBu crosslinker", 213.111341, 213.233700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1330: {
      Modification mod("bisANS-sulfonates", "BisANS with loss of both sulfonates", 434.178299, 434.530500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1331: {
      Modification mod("DNCB_hapten", "Chemical reaction with 2,4-dinitro-1-chloro benzene (DNCB)", 166.001457, 166.091100);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1326: {
      Modification mod("NEMsulfur", "N-ethylmaleimideSulfur", 157.019749, 157.190300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1327: {
      Modification mod("SulfurDioxide", "SulfurDioxide", 63.961900, 64.063800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1328: {
      Modification mod("NEMsulfurWater", "N-ethylmaleimideSulfurWater", 175.030314, 175.205600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1389: {
      Modification mod("HN3_mustard", "Modification by hydroxylated tris-(2-chloroethyl)amine (HN-3)", 131.094629, 131.172900);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1387: {
      Modification mod("3-phosphoglyceryl", "3-phosphoglyceryl", 167.982375, 168.042000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1388: {
      Modification mod("HN2_mustard", "Modification by hydroxylated mechloroethamine (HN-2)", 101.084064, 101.146900);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1358: {
      Modification mod("NEM:2H(5)+H2O", "D5 N-ethylmaleimide+water on cysteines", 148.089627, 148.171400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1363: {
      Modification mod("Crotonyl", "Crotonylation", 68.026215, 68.074000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1364: {
      Modification mod("O-Et-N-diMePhospho", "O-ethyl, N-dimethyl phosphate", 135.044916, 135.101500);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1365: {
      Modification mod("N-dimethylphosphate", "N-dimethylphosphate", 107.013615, 107.048300);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1356: {
      Modification mod("phosphoRibosyl", "phosphate-ribosylation", 212.008590, 212.094500);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1355: {
      Modification mod("azole", "Formation of five membered aromatic heterocycle", -20.026215, -20.031200);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1340: {
      Modification mod("Biotin:Thermo-21911", "Biotin-PEG11-maleimide", 921.461652, 922.091300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1341: {
      Modification mod("iodoTMT", "Native iodoacetyl Tandem Mass Tag", 324.216141, 324.418500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1342: {
      Modification mod("iodoTMT6plex", "Sixplex iodoacetyl Tandem Mass Tag", 329.226595, 329.382500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1787: {
      Modification mod("Label:13C(2)15N(2)", "13C(2) 15N(2)", 4.000780, 3.972100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1344: {
      Modification mod("Phosphogluconoylation", "Phosphogluconoylation", 258.014069, 258.119900);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1368: {
      Modification mod("Methyl:2H(3)+Acetyl:2H(3)", "3-fold methylated lysine labelled with Acetyl_heavy", 62.063875, 62.100200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1367: {
      Modification mod("dHex(1)Hex(1)", "Hex1dHex1", 308.110732, 308.281800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1380: {
      Modification mod("methylsulfonylethyl", "reaction with methyl vinyl sulfone", 106.008850, 106.143500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1370: {
      Modification mod("Label:2H(3)+Oxidation", "Oxidised 2H(3) labelled Methionine", 19.013745, 19.017900);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1371: {
      Modification mod("Trimethyl:2H(9)", "3-fold methylation with deuterated methyl groups", 51.103441, 51.135200);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1372: {
      Modification mod("Acetyl:13C(2)", "heavy acetylation", 44.017274, 44.022000);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1375: {
      Modification mod("dHex(1)Hex(2)", "Hex2dHex1", 470.163556, 470.422400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1376: {
      Modification mod("dHex(1)Hex(3)", "Hex3dHex1", 632.216379, 632.563000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1377: {
      Modification mod("dHex(1)Hex(4)", "Hex4dHex1", 794.269203, 794.703600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1378: {
      Modification mod("dHex(1)Hex(5)", "Hex5dHex1", 956.322026, 956.844200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1379: {
      Modification mod("dHex(1)Hex(6)", "Hex6dHex1", 1118.374850, 1118.984800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1381: {
      Modification mod("ethylsulfonylethyl", "reaction with ethyl vinyl sulfone", 120.024500, 120.170100);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1382: {
      Modification mod("phenylsulfonylethyl", "reaction with phenyl vinyl sulfone", 168.024500, 168.212900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1383: {
      Modification mod("PyridoxalPhosphateH2", "PLP bound to lysine reduced by sodium borohydride (NaBH4) to create amine linkage", 231.029660, 231.142500);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1384: {
      Modification mod("Homocysteic_acid", "methionine oxidation to homocysteic acid", 33.969094, 33.971600);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1385: {
      Modification mod("Hydroxamic_acid", "ADP-ribosylation followed by conversion to hydroxamic acid via hydroxylamine", 15.010899, 15.014600);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 1390: {
      Modification mod("Oxidation+NEM", "N-ethylmaleimide on cysteine sulfenic acid", 141.042593, 141.124700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1391: {
      Modification mod("NHS-fluorescein", "fluorescein-hexanoate-NHS hydrolysis", 471.131802, 471.458100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1392: {
      Modification mod("DiART6plex", "Representative mass and accurate mass for 114", 217.162932, 217.252700);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1393: {
      Modification mod("DiART6plex115", "Accurate mass for DiART6plex 115", 217.156612, 217.253500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1394: {
      Modification mod("DiART6plex116/119", "Accurate mass for DiART6plex 116 and 119", 217.168776, 217.279700);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1395: {
      Modification mod("DiART6plex117", "Accurate mass for DiART6plex 117", 217.162456, 217.280500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1396: {
      Modification mod("DiART6plex118", "Accurate mass for DiART6plex 118", 217.175096, 217.279000);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1397: {
      Modification mod("Iodoacetanilide", "iodoacetanilide derivative", 133.052764, 133.147300);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1398: {
      Modification mod("Iodoacetanilide:13C(6)", "13C labelled iodoacetanilide derivative", 139.072893, 139.103200);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1399: {
      Modification mod("Dap-DSP", "Diaminopimelic acid-DSP monolinked", 364.076278, 364.437700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1400: {
      Modification mod("MurNAc", "N-Acetylmuramic acid", 275.100502, 275.255200);
      mod.addSpecificity('A', ANYWHERE);
      return mod;
    }
    case 1405: {
      Modification mod("EEEDVIEVYQEQTGG", "Sumoylation by SUMO-1 after Cyanogen bromide (CNBr) cleavage", 1705.731890, 1706.715300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1402: {
      Modification mod("Label:2H(7)15N(4)", "Label:2H(7)15N(4)", 11.032077, 11.016800);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1403: {
      Modification mod("Label:2H(6)15N(1)", "Label:2H(6)15N(1)", 7.034695, 7.030400);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1406: {
      Modification mod("EDEDTIDVFQQQTGG", "Sumoylation by SUMO-2/3 after Cyanogen bromide (CNBr) cleavage", 1662.700924, 1663.650800);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1408: {
      Modification mod("Hex(5)HexNAc(4)NeuAc(2)", "A2G2S2/G2S2", 2204.772441, 2205.982200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1409: {
      Modification mod("Hex(5)HexNAc(4)NeuAc(1)", "A2G2S1/G2S1", 1913.677025, 1914.727700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1410: {
      Modification mod("dHex(1)Hex(5)HexNAc(4)NeuAc(1)", "FA2G2S1/G2FS1", 2059.734933, 2060.868900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1411: {
      Modification mod("dHex(1)Hex(5)HexNAc(4)NeuAc(2)", "FA2G2S2/G2FS2", 2350.830350, 2352.123400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1412: {
      Modification mod("s-GlcNAc", "O3S1HexNAc1", 283.036187, 283.255700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1413: {
      Modification mod("PhosphoHex(2)", "H1O3P1Hex2", 404.071978, 404.261100);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1414: {
      Modification mod("Trimethyl:13C(3)2H(9)", "3-fold methylation with fully labelled methyl groups", 54.113505, 54.113200);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1419: {
      Modification mod("15N-oxobutanoic", "Loss of ammonia (15N)", -18.023584, -18.023900);
      mod.addSpecificity('S', PROTEIN_N);
      mod.addSpecificity('C', ANY_N);
      mod.addSpecificity('T', PROTEIN_N);
      return mod;
    }
    case 1421: {
      Modification mod("spermidine", "spermidine adduct", 128.131349, 128.215300);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1423: {
      Modification mod("Biotin:Thermo-21330", "Biotin_PEG4", 473.219571, 473.583500);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1428: {
      Modification mod("Hex(1)Pent(2)", "Hex Pent(2)", 426.137341, 426.369800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1425: {
      Modification mod("Pentose", "Pentose", 132.042259, 132.114600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1426: {
      Modification mod("Hex(1)Pent(1)", "Hex Pent", 294.095082, 294.255200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1427: {
      Modification mod("Hex(1)HexA(1)", "Hex HexA", 338.084912, 338.264700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1429: {
      Modification mod("Hex(1)HexNAc(1)Phos(1)", "Hex HexNAc Phos", 445.098527, 445.313000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1430: {
      Modification mod("Hex(1)HexNAc(1)Sulf(1)", "Hex HexNAc Sulf", 445.089011, 445.396300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1431: {
      Modification mod("Hex(1)NeuAc(1)", "Hex NeuAc ---OR--- HexNAc Kdn", 453.148240, 453.395200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1432: {
      Modification mod("Hex(1)NeuGc(1)", "Hex NeuGc", 469.143155, 469.394600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1433: {
      Modification mod("HexNAc(3)", "HexNAc(3)", 609.238118, 609.577600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1434: {
      Modification mod("HexNAc(1)NeuAc(1)", "HexNAc NeuAc", 494.174789, 494.447100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1435: {
      Modification mod("HexNAc(1)NeuGc(1)", "HexNAc NeuGc", 510.169704, 510.446500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1444: {
      Modification mod("Hex(2)NeuAc(1)", "Hex(2) NeuAc ---OR--- Hex HexNAc Kdn", 615.201064, 615.535800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1436: {
      Modification mod("Hex(1)HexNAc(1)dHex(1)Me(1)", "Hex HexNAc dHex Me", 525.205755, 525.500900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1437: {
      Modification mod("Hex(1)HexNAc(1)dHex(1)Me(2)", "Hex HexNAc dHex Me(2)", 539.221405, 539.527500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1789: {
      Modification mod("Xlink:DSS[155]", "Ammonium-quenched monolink of DSS/BS3 crosslinker", 155.094629, 155.194300);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1438: {
      Modification mod("Hex(2)HexNAc(1)", "Hex(2) HexNAc", 527.185020, 527.473700);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1439: {
      Modification mod("Hex(1)HexA(1)HexNAc(1)", "Hex HexA HexNAc", 541.164284, 541.457200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1440: {
      Modification mod("Hex(2)HexNAc(1)Me(1)", "Hex(2) HexNAc Me", 541.200670, 541.500300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1441: {
      Modification mod("Hex(1)Pent(3)", "Hex Pent(3)", 558.179600, 558.484500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1442: {
      Modification mod("Hex(1)NeuAc(1)Pent(1)", "Hex NeuAc Pent", 585.190499, 585.509800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1443: {
      Modification mod("Hex(2)HexNAc(1)Sulf(1)", "Hex(2) HexNAc Sulf", 607.141834, 607.536900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1445: {
      Modification mod("dHex(2)Hex(2)", "Hex2 dHex2", 616.221465, 616.563600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1446: {
      Modification mod("dHex(1)Hex(2)HexA(1)", "dHex Hex(2) HexA", 646.195644, 646.546500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1447: {
      Modification mod("Hex(1)HexNAc(2)Sulf(1)", "Hex HexNAc(2) Sulf", 648.168383, 648.588800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1448: {
      Modification mod("Hex(4)", "Hex(4)", 648.211294, 648.562400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1449: {
      Modification mod("dHex(1)Hex(2)HexNAc(2)Pent(1)", "dHex Hex(2) HexNAc(2) Pent", 1008.364560, 1008.922100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1450: {
      Modification mod("Hex(2)HexNAc(2)NeuAc(1)", "Hex(2) HexNAc(2) NeuAc ---OR--- dHex Hex HexNAc(2) NeuGc", 1021.359809, 1021.920800);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1451: {
      Modification mod("Hex(3)HexNAc(2)Pent(1)", "Hex(3) HexNAc(2) Pent", 1024.359475, 1024.921500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1452: {
      Modification mod("Hex(4)HexNAc(2)", "Hex(4) HexNAc(2)", 1054.370039, 1054.947400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1453: {
      Modification mod("dHex(1)Hex(4)HexNAc(1)Pent(1)", "dHex Hex(4) HexNAc Pent", 1129.390834, 1130.010700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1454: {
      Modification mod("dHex(1)Hex(3)HexNAc(2)Pent(1)", "dHex Hex(3) HexNAc(2) Pent", 1170.417383, 1171.062700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1455: {
      Modification mod("Hex(3)HexNAc(2)NeuAc(1)", "Hex(3) HexNAc(2) NeuAc", 1183.412632, 1184.061400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1456: {
      Modification mod("Hex(4)HexNAc(2)Pent(1)", "Hex(4) HexNAc(2) Pent", 1186.412298, 1187.062100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1457: {
      Modification mod("Hex(3)HexNAc(3)Pent(1)", "Hex(3) HexNAc(3) Pent", 1227.438847, 1228.114000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1458: {
      Modification mod("Hex(5)HexNAc(2)Phos(1)", "Hex(5) HexNAc(2) Phos", 1296.389194, 1297.067900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1459: {
      Modification mod("dHex(1)Hex(4)HexNAc(2)Pent(1)", "dHex Hex(4) HexNAc(2) Pent", 1332.470207, 1333.203300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1460: {
      Modification mod("Hex(7)HexNAc(1)", "Hex(7) HexNAc", 1337.449137, 1338.176700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1461: {
      Modification mod("Hex(4)HexNAc(2)NeuAc(1)", "Hex(4) HexNAc(2) NeuAc ---OR--- Hex(3) HexNAc(2) dHex NeuGc", 1345.465456, 1346.202000);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1462: {
      Modification mod("dHex(1)Hex(5)HexNAc(2)", "dHex Hex(5) HexNAc(2)", 1362.480772, 1363.229200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1463: {
      Modification mod("dHex(1)Hex(3)HexNAc(3)Pent(1)", "dHex Hex(3) HexNAc(3) Pent", 1373.496756, 1374.255200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1464: {
      Modification mod("Hex(3)HexNAc(4)Sulf(1)", "Hex(3) HexNAc(4) Sulf", 1378.432776, 1379.255100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1465: {
      Modification mod("Hex(6)HexNAc(2)", "M6/Man6", 1378.475686, 1379.228600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1466: {
      Modification mod("Hex(4)HexNAc(3)Pent(1)", "Hex(4) HexNAc(3) Pent", 1389.491671, 1390.254600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1467: {
      Modification mod("dHex(1)Hex(4)HexNAc(3)", "dHex Hex(4) HexNAc(3)", 1403.507321, 1404.281200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1468: {
      Modification mod("Hex(5)HexNAc(3)", "Hex(5) HexNAc(3)", 1419.502235, 1420.280600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1469: {
      Modification mod("Hex(3)HexNAc(4)Pent(1)", "Hex(3) HexNAc(4) Pent", 1430.518220, 1431.306500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1470: {
      Modification mod("Hex(6)HexNAc(2)Phos(1)", "Hex(6) HexNAc(2) Phos", 1458.442017, 1459.208500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1471: {
      Modification mod("dHex(1)Hex(4)HexNAc(3)Sulf(1)", "dHex Hex(4) HexNAc(3) Sulf", 1483.464135, 1484.344400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1472: {
      Modification mod("dHex(1)Hex(5)HexNAc(2)Pent(1)", "dHex Hex(5) HexNAc(2) Pent", 1494.523030, 1495.343900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1473: {
      Modification mod("Hex(8)HexNAc(1)", "Hex(8) HexNAc", 1499.501961, 1500.317300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1474: {
      Modification mod("dHex(1)Hex(3)HexNAc(3)Pent(2)", "dHex Hex(3) HexNAc(3) Pent(2)", 1505.539015, 1506.369800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1475: {
      Modification mod("dHex(2)Hex(3)HexNAc(3)Pent(1)", "dHex(2) Hex(3) HexNAc(3) Pent", 1519.554665, 1520.396400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1476: {
      Modification mod("dHex(1)Hex(3)HexNAc(4)Sulf(1)", "dHex Hex(3) HexNAc(4) Sulf", 1524.490684, 1525.396300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1477: {
      Modification mod("dHex(1)Hex(6)HexNAc(2)", "dHex Hex(6) HexNAc(2)", 1524.533595, 1525.369800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1478: {
      Modification mod("dHex(1)Hex(4)HexNAc(3)Pent(1)", "dHex Hex(4) HexNAc(3) Pent", 1535.549579, 1536.395800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1479: {
      Modification mod("Hex(4)HexNAc(4)Sulf(1)", "Hex(4) HexNAc(4) Sulf", 1540.485599, 1541.395700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1480: {
      Modification mod("Hex(7)HexNAc(2)", "M7/Man7", 1540.528510, 1541.369200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1481: {
      Modification mod("dHex(2)Hex(4)HexNAc(3)", "dHex(2) Hex(4) HexNAc(3)", 1549.565230, 1550.422400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1482: {
      Modification mod("Hex(5)HexNAc(3)Pent(1)", "Hex(5) HexNAc(3) Pent", 1551.544494, 1552.395200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1483: {
      Modification mod("Hex(4)HexNAc(3)NeuGc(1)", "Hex(4) HexNAc(3) NeuGc", 1564.539743, 1565.393900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1484: {
      Modification mod("dHex(1)Hex(5)HexNAc(3)", "dHex Hex(5) HexNAc(3)", 1565.560144, 1566.421800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1485: {
      Modification mod("dHex(1)Hex(3)HexNAc(4)Pent(1)", "dHex Hex(3) HexNAc(4) Pent", 1576.576129, 1577.447700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1486: {
      Modification mod("Hex(3)HexNAc(5)Sulf(1)", "Hex(3) HexNAc(5) Sulf", 1581.512148, 1582.447600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1487: {
      Modification mod("Hex(6)HexNAc(3)", "Hex(6) HexNAc(3)", 1581.555059, 1582.421200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1488: {
      Modification mod("Hex(3)HexNAc(4)NeuAc(1)", "Hex(3) HexNAc(4) NeuAc ---OR--- Hex(2) HexNAc(4) dHex NeuGc", 1589.571378, 1590.446500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1489: {
      Modification mod("Hex(4)HexNAc(4)Pent(1)", "Hex(4) HexNAc(4) Pent", 1592.571043, 1593.447100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1490: {
      Modification mod("Hex(7)HexNAc(2)Phos(1)", "Hex(7) HexNAc(2) Phos", 1620.494841, 1621.349100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1491: {
      Modification mod("Hex(4)HexNAc(4)Me(2)Pent(1)", "Hex(4) HexNAc(4) Me(2) Pent", 1620.602343, 1621.500300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1492: {
      Modification mod("dHex(1)Hex(3)HexNAc(3)Pent(3)", "dHex Hex(3) HexNAc(3) Pent(3) ---OR--- Hex(4) HexNAc(2) dHex(2) NeuAc", 1637.581274, 1638.484400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1493: {
      Modification mod("dHex(1)Hex(5)HexNAc(3)Sulf(1)", "dHex Hex(5) HexNAc(3) Sulf", 1645.516959, 1646.485000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1494: {
      Modification mod("dHex(2)Hex(3)HexNAc(3)Pent(2)", "dHex(2) Hex(3) HexNAc(3) Pent(2)", 1651.596924, 1652.511000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1495: {
      Modification mod("Hex(6)HexNAc(3)Phos(1)", "Hex(6) HexNAc(3) Phos", 1661.521390, 1662.401100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1496: {
      Modification mod("Hex(4)HexNAc(5)", "Hex(4) HexNAc(5)", 1663.608157, 1664.525000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1497: {
      Modification mod("dHex(3)Hex(3)HexNAc(3)Pent(1)", "dHex(3) Hex(3) HexNAc(3) Pent", 1665.612574, 1666.537600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1498: {
      Modification mod("dHex(2)Hex(4)HexNAc(3)Pent(1)", "dHex(2) Hex(4) HexNAc(3) Pent", 1681.607488, 1682.537000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1499: {
      Modification mod("dHex(1)Hex(4)HexNAc(4)Sulf(1)", "dHex Hex(4) HexNAc(4) Sulf", 1686.543508, 1687.536900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1500: {
      Modification mod("dHex(1)Hex(7)HexNAc(2)", "dHex Hex(7) HexNAc(2)", 1686.586419, 1687.510400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1501: {
      Modification mod("dHex(1)Hex(4)HexNAc(3)NeuAc(1)", "dHex Hex(4) HexNAc(3) NeuAc ---OR--- dHex(2) Hex(3) HexNAc(3) NeuGc", 1694.602737, 1695.535700);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1502: {
      Modification mod("Hex(7)HexNAc(2)Phos(2)", "Hex(7) HexNAc(2) Phos(2)", 1700.461172, 1701.329000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1503: {
      Modification mod("Hex(5)HexNAc(4)Sulf(1)", "Hex(5) HexNAc(4) Sulf", 1702.538423, 1703.536300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1504: {
      Modification mod("Hex(8)HexNAc(2)", "M8/Man8", 1702.581333, 1703.509800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1505: {
      Modification mod("dHex(1)Hex(3)HexNAc(4)Pent(2)", "dHex Hex(3) HexNAc(4) Pent(2)", 1708.618387, 1709.562300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1506: {
      Modification mod("dHex(1)Hex(4)HexNAc(3)NeuGc(1)", "dHex Hex(4) HexNAc(3) NeuGc ---OR--- Hex(5) HexNAc(3) NeuAc", 1710.597652, 1711.535100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1507: {
      Modification mod("dHex(2)Hex(3)HexNAc(4)Pent(1)", "dHex(2) Hex(3) HexNAc(4) Pent", 1722.634037, 1723.588900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1508: {
      Modification mod("dHex(1)Hex(3)HexNAc(5)Sulf(1)", "dHex Hex(3) HexNAc(5) Sulf", 1727.570057, 1728.588800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1509: {
      Modification mod("dHex(1)Hex(6)HexNAc(3)", "dHex Hex(6) HexNAc(3)", 1727.612968, 1728.562400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1510: {
      Modification mod("dHex(1)Hex(3)HexNAc(4)NeuAc(1)", "dHex Hex(3) HexNAc(4) NeuAc", 1735.629286, 1736.587700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1511: {
      Modification mod("dHex(3)Hex(3)HexNAc(4)", "dHex(3) Hex(3) HexNAc(4)", 1736.649688, 1737.615500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1512: {
      Modification mod("dHex(1)Hex(4)HexNAc(4)Pent(1)", "dHex Hex(4) HexNAc(4) Pent", 1738.628952, 1739.588300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1513: {
      Modification mod("Hex(4)HexNAc(5)Sulf(1)", "Hex(4) HexNAc(5) Sulf", 1743.564972, 1744.588200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1514: {
      Modification mod("Hex(7)HexNAc(3)", "Hex(7) HexNAc(3)", 1743.607882, 1744.561800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1515: {
      Modification mod("dHex(1)Hex(4)HexNAc(3)NeuAc(1)Sulf(1)", "dHex Hex(4) HexNAc(3) NeuAc Sulf", 1774.559552, 1775.598900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1516: {
      Modification mod("Hex(5)HexNAc(4)Me(2)Pent(1)", "Hex(5) HexNAc(4) Me(2) Pent", 1782.655167, 1783.640900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1517: {
      Modification mod("Hex(3)HexNAc(6)Sulf(1)", "Hex(3) HexNAc(6) Sulf", 1784.591521, 1785.640100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1518: {
      Modification mod("dHex(1)Hex(6)HexNAc(3)Sulf(1)", "dHex Hex(6) HexNAc(3) Sulf", 1807.569782, 1808.625600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1519: {
      Modification mod("dHex(1)Hex(4)HexNAc(5)", "dHex Hex(4) HexNAc(5)", 1809.666066, 1810.666200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1520: {
      Modification mod("dHex(1)Hex(5)HexA(1)HexNAc(3)Sulf(1)", "dHex Hex(5) HexA HexNAc(3) Sulf", 1821.549047, 1822.609100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1521: {
      Modification mod("Hex(7)HexNAc(3)Phos(1)", "Hex(7) HexNAc(3) Phos", 1823.574213, 1824.541700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1522: {
      Modification mod("Hex(6)HexNAc(4)Me(3)", "Hex(6) HexNAc(4) Me(3)", 1826.681382, 1827.693400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1523: {
      Modification mod("dHex(2)Hex(4)HexNAc(4)Sulf(1)", "dHex(2) Hex(4) HexNAc(4) Sulf", 1832.601417, 1833.678100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1524: {
      Modification mod("Hex(4)HexNAc(3)NeuAc(2)", "Hex(4) HexNAc(3) NeuAc(2)", 1839.640245, 1840.649100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1525: {
      Modification mod("dHex(1)Hex(3)HexNAc(4)Pent(3)", "dHex Hex(3) HexNAc(4) Pent(3)", 1840.660646, 1841.676900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1526: {
      Modification mod("dHex(2)Hex(5)HexNAc(3)Pent(1)", "dHex(2) Hex(5) HexNAc(3) Pent", 1843.660312, 1844.677600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1527: {
      Modification mod("dHex(1)Hex(5)HexNAc(4)Sulf(1)", "dHex Hex(5) HexNAc(4) Sulf", 1848.596331, 1849.677500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1528: {
      Modification mod("dHex(2)Hex(3)HexNAc(4)Pent(2)", "dHex(2) Hex(3) HexNAc(4) Pent(2)", 1854.676296, 1855.703500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1529: {
      Modification mod("dHex(1)Hex(5)HexNAc(3)NeuAc(1)", "dHex Hex(5) HexNAc(3) NeuAc", 1856.655561, 1857.676300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1530: {
      Modification mod("Hex(3)HexNAc(6)Sulf(2)", "Hex(3) HexNAc(6) Sulf(2)", 1864.548335, 1865.703300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1531: {
      Modification mod("Hex(9)HexNAc(2)", "M9/Man9", 1864.634157, 1865.650400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1532: {
      Modification mod("Hex(4)HexNAc(6)", "Hex(4) HexNAc(6)", 1866.687530, 1867.717500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1533: {
      Modification mod("dHex(3)Hex(3)HexNAc(4)Pent(1)", "dHex(3) Hex(3) HexNAc(4) Pent", 1868.691946, 1869.730100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1534: {
      Modification mod("dHex(1)Hex(5)HexNAc(3)NeuGc(1)", "dHex Hex(5) HexNAc(3) NeuGc ---OR--- Hex(6) HexNAc(3) NeuAc", 1872.650475, 1873.675700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1535: {
      Modification mod("dHex(2)Hex(4)HexNAc(4)Pent(1)", "dHex(2) Hex(4) HexNAc(4) Pent", 1884.686861, 1885.729500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1536: {
      Modification mod("dHex(1)Hex(4)HexNAc(5)Sulf(1)", "dHex Hex(4) HexNAc(5) Sulf", 1889.622880, 1890.729400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1537: {
      Modification mod("dHex(1)Hex(7)HexNAc(3)", "dHex Hex(7) HexNAc(3)", 1889.665791, 1890.703000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1538: {
      Modification mod("dHex(1)Hex(5)HexNAc(4)Pent(1)", "dHex Hex(5) HexNAc(4) Pent", 1900.681776, 1901.728900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1539: {
      Modification mod("dHex(1)Hex(5)HexA(1)HexNAc(3)Sulf(2)", "dHex Hex(5) HexA HexNAc(3) Sulf(2)", 1901.505861, 1902.672300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1540: {
      Modification mod("Hex(3)HexNAc(7)", "Hex(3) HexNAc(7)", 1907.714079, 1908.769400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1541: {
      Modification mod("dHex(2)Hex(5)HexNAc(4)", "dHex(2) Hex(5) HexNAc(4)", 1914.697426, 1915.755500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1542: {
      Modification mod("dHex(2)Hex(4)HexNAc(3)NeuAc(1)Sulf(1)", "dHex(2) Hex(4) HexNAc(3) NeuAc Sulf", 1920.617461, 1921.740100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1543: {
      Modification mod("dHex(1)Hex(5)HexNAc(4)Sulf(2)", "dHex Hex(5) HexNAc(4) Sulf(2)", 1928.553146, 1929.740700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1544: {
      Modification mod("dHex(1)Hex(5)HexNAc(4)Me(2)Pent(1)", "dHex Hex(5) HexNAc(4) Me(2) Pent", 1928.713076, 1929.782100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1545: {
      Modification mod("Hex(5)HexNAc(4)NeuGc(1)", "Hex(5) HexNAc(4) NeuGc", 1929.671939, 1930.727100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1546: {
      Modification mod("dHex(1)Hex(3)HexNAc(6)Sulf(1)", "dHex Hex(3) HexNAc(6) Sulf", 1930.649430, 1931.781300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1547: {
      Modification mod("dHex(1)Hex(6)HexNAc(4)", "dHex Hex(6) HexNAc(4)", 1930.692340, 1931.754900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1548: {
      Modification mod("dHex(1)Hex(5)HexNAc(3)NeuAc(1)Sulf(1)", "dHex Hex(5) HexNAc(3) NeuAc Sulf", 1936.612375, 1937.739500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1549: {
      Modification mod("Hex(7)HexNAc(4)", "Hex(7) HexNAc(4)", 1946.687255, 1947.754300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1550: {
      Modification mod("dHex(1)Hex(5)HexNAc(3)NeuGc(1)Sulf(1)", "dHex Hex(5) HexNAc(3) NeuGc Sulf", 1952.607290, 1953.738900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1551: {
      Modification mod("Hex(4)HexNAc(5)NeuAc(1)", "Hex(4) HexNAc(5) NeuAc", 1954.703574, 1955.779600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1552: {
      Modification mod("Hex(6)HexNAc(4)Me(3)Pent(1)", "Hex(6) HexNAc(4) Me(3) Pent", 1958.723640, 1959.808000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1553: {
      Modification mod("dHex(1)Hex(7)HexNAc(3)Sulf(1)", "dHex Hex(7) HexNAc(3) Sulf", 1969.622606, 1970.766200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1554: {
      Modification mod("dHex(1)Hex(7)HexNAc(3)Phos(1)", "dHex Hex(7) HexNAc(3) Phos", 1969.632122, 1970.682900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1555: {
      Modification mod("dHex(1)Hex(5)HexNAc(5)", "dHex Hex(5) HexNAc(5)", 1971.718889, 1972.806800);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1556: {
      Modification mod("dHex(1)Hex(4)HexNAc(4)NeuAc(1)Sulf(1)", "dHex Hex(4) HexNAc(4) NeuAc Sulf", 1977.638925, 1978.791500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1557: {
      Modification mod("dHex(3)Hex(4)HexNAc(4)Sulf(1)", "dHex(3) Hex(4) HexNAc(4) Sulf", 1978.659326, 1979.819300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1558: {
      Modification mod("Hex(3)HexNAc(7)Sulf(1)", "Hex(3) HexNAc(7) Sulf", 1987.670893, 1988.832600);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1559: {
      Modification mod("Hex(6)HexNAc(5)", "A3G3", 1987.713804, 1988.806200);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1560: {
      Modification mod("Hex(5)HexNAc(4)NeuAc(1)Sulf(1)", "Hex(5) HexNAc(4) NeuAc Sulf", 1993.633839, 1994.790900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1561: {
      Modification mod("Hex(3)HexNAc(6)NeuAc(1)", "Hex(3) HexNAc(6) NeuAc", 1995.730123, 1996.831500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1562: {
      Modification mod("dHex(2)Hex(3)HexNAc(6)", "dHex(2) Hex(3) HexNAc(6)", 1996.750524, 1997.859300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1563: {
      Modification mod("Hex(1)HexNAc(1)NeuGc(1)", "Hex HexNAc NeuGc", 672.222527, 672.587100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1564: {
      Modification mod("dHex(1)Hex(2)HexNAc(1)", "dHex Hex(2) HexNAc", 673.242928, 673.614900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1565: {
      Modification mod("HexNAc(3)Sulf(1)", "HexNAc(3) Sulf", 689.194932, 689.640800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1566: {
      Modification mod("Hex(3)HexNAc(1)", "Hex(3) HexNAc", 689.237843, 689.614300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1567: {
      Modification mod("Hex(1)HexNAc(1)Kdn(1)Sulf(1)", "Hex HexNAc Kdn Sulf", 695.157878, 695.599000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1568: {
      Modification mod("HexNAc(2)NeuAc(1)", "HexNAc(2) NeuAc", 697.254162, 697.639600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1570: {
      Modification mod("HexNAc(1)Kdn(2)", "HexNAc Kdn(2) ---OR--- Hex(2) HexNAc HexA", 703.217108, 703.597800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1571: {
      Modification mod("Hex(3)HexNAc(1)Me(1)", "Hex(3) HexNAc Me", 703.253493, 703.640900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1572: {
      Modification mod("Hex(2)HexA(1)Pent(1)Sulf(1)", "Hex(2) HexA Pent Sulf", 712.136808, 712.583100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1573: {
      Modification mod("HexNAc(2)NeuGc(1)", "HexNAc(2) NeuGc", 713.249076, 713.639000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1575: {
      Modification mod("Hex(4)Phos(1)", "Hex(4) Phos", 728.177625, 728.542300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1577: {
      Modification mod("Hex(1)HexNAc(1)NeuAc(1)Sulf(1)", "Hex HexNAc NeuAc Sulf", 736.184427, 736.650900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1578: {
      Modification mod("Hex(1)HexA(1)HexNAc(2)", "Hex HexA HexNAc(2)", 744.243657, 744.649800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1579: {
      Modification mod("dHex(1)Hex(2)HexNAc(1)Sulf(1)", "dHex Hex(2) HexNAc Sulf", 753.199743, 753.678100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1580: {
      Modification mod("dHex(1)HexNAc(3)", "dHex HexNAc(3)", 755.296027, 755.718800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1581: {
      Modification mod("dHex(1)Hex(1)HexNAc(1)Kdn(1)", "dHex Hex HexNAc Kdn ---OR--- Hex(2) dHex NeuAc", 761.258973, 761.677000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1582: {
      Modification mod("Hex(1)HexNAc(3)", "Hex HexNAc(3)", 771.290941, 771.718200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1583: {
      Modification mod("HexNAc(2)NeuAc(1)Sulf(1)", "HexNAc(2) NeuAc Sulf", 777.210976, 777.702800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1584: {
      Modification mod("dHex(2)Hex(3)", "dHex(2) Hex(3)", 778.274288, 778.704200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1585: {
      Modification mod("Hex(2)HexA(1)HexNAc(1)Sulf(1)", "Hex(2) HexA HexNAc Sulf", 783.173922, 783.661000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1586: {
      Modification mod("dHex(2)Hex(2)HexA(1)", "dHex(2) Hex(2) HexA", 792.253553, 792.687700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1587: {
      Modification mod("dHex(1)Hex(1)HexNAc(2)Sulf(1)", "dHex Hex HexNAc(2) Sulf", 794.226292, 794.730000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1588: {
      Modification mod("dHex(1)Hex(1)HexNAc(1)NeuAc(1)", "dHex Hex HexNAc NeuAc", 802.285522, 802.728900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1589: {
      Modification mod("Hex(2)HexNAc(2)Sulf(1)", "Hex(2) HexNAc(2) Sulf", 810.221207, 810.729400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1590: {
      Modification mod("Hex(5)", "Hex(5)", 810.264117, 810.703000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1591: {
      Modification mod("HexNAc(4)", "HexNAc(4)", 812.317490, 812.770100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1592: {
      Modification mod("HexNAc(1)NeuGc(2)", "HexNAc NeuGc(2)", 817.260035, 817.700500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1593: {
      Modification mod("dHex(1)Hex(1)HexNAc(1)NeuGc(1)", "dHex Hex HexNAc NeuGc ---OR--- Hex(2) HexNAc NeuAc", 818.280436, 818.728300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1594: {
      Modification mod("dHex(2)Hex(2)HexNAc(1)", "dHex(2) Hex(2) HexNAc", 819.300837, 819.756100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1595: {
      Modification mod("Hex(2)HexNAc(1)NeuGc(1)", "Hex(2) HexNAc NeuGc", 834.275351, 834.727700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1596: {
      Modification mod("dHex(1)Hex(3)HexNAc(1)", "dHex Hex(3) HexNAc", 835.295752, 835.755500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1597: {
      Modification mod("dHex(1)Hex(2)HexA(1)HexNAc(1)", "dHex Hex(2) HexA HexNAc", 849.275017, 849.739000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1598: {
      Modification mod("Hex(1)HexNAc(3)Sulf(1)", "Hex HexNAc(3) Sulf", 851.247756, 851.781400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1599: {
      Modification mod("Hex(4)HexNAc(1)", "Hex(4) HexNAc", 851.290667, 851.754900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1600: {
      Modification mod("Hex(1)HexNAc(2)NeuAc(1)", "Hex HexNAc(2) NeuAc", 859.306985, 859.780200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1602: {
      Modification mod("Hex(1)HexNAc(2)NeuGc(1)", "Hex HexNAc(2) NeuGc", 875.301900, 875.779600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1604: {
      Modification mod("Hex(5)Phos(1)", "Hex(5) Phos", 890.230448, 890.682900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1606: {
      Modification mod("dHex(2)Hex(1)HexNAc(1)Kdn(1)", "dHex(2) Hex HexNAc Kdn", 907.316881, 907.818200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1607: {
      Modification mod("dHex(1)Hex(3)HexNAc(1)Sulf(1)", "dHex Hex(3) HexNAc Sulf", 915.252567, 915.818700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1608: {
      Modification mod("dHex(1)Hex(1)HexNAc(3)", "dHex Hex HexNAc(3)", 917.348850, 917.859400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1609: {
      Modification mod("dHex(1)Hex(2)HexA(1)HexNAc(1)Sulf(1)", "dHex Hex(2) HexA HexNAc Sulf", 929.231831, 929.802200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1610: {
      Modification mod("Hex(2)HexNAc(3)", "Hex(2) HexNAc(3)", 933.343765, 933.858800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1611: {
      Modification mod("Hex(1)HexNAc(2)NeuAc(1)Sulf(1)", "Hex HexNAc(2) NeuAc Sulf", 939.263800, 939.843400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1612: {
      Modification mod("dHex(2)Hex(4)", "dHex(2) Hex(4)", 940.327112, 940.844800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1786: {
      Modification mod("Hex(1)HexNAc(1)NeuAc(1)Ac(1)", "Ac Hex HexNAc NeuAc", 698.238177, 698.624400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1614: {
      Modification mod("dHex(2)HexNAc(2)Kdn(1)", "dHex(2) HexNAc(2) Kdn", 948.343430, 948.870100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1615: {
      Modification mod("dHex(1)Hex(2)HexNAc(2)Sulf(1)", "dHex Hex(2) HexNAc(2) Sulf", 956.279116, 956.870600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1616: {
      Modification mod("dHex(1)HexNAc(4)", "dHex HexNAc(4)", 958.375399, 958.911300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1617: {
      Modification mod("Hex(1)HexNAc(1)NeuAc(1)NeuGc(1)", "Hex HexNAc NeuAc NeuGc", 963.317944, 963.841700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1618: {
      Modification mod("dHex(1)Hex(1)HexNAc(2)Kdn(1)", "dHex Hex HexNAc(2) Kdn ---OR--- Hex(2) HexNAc dHex NeuAc", 964.338345, 964.869500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1619: {
      Modification mod("Hex(1)HexNAc(1)NeuGc(2)", "Hex HexNAc NeuGc(2)", 979.312859, 979.841100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1620: {
      Modification mod("Hex(1)HexNAc(1)NeuAc(2)Ac(1)", "Ac Hex HexNAc NeuAc(2)", 989.333594, 989.879000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1621: {
      Modification mod("dHex(2)Hex(2)HexA(1)HexNAc(1)", "dHex(2) Hex(2) HexA HexNAc", 995.332925, 995.880200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1622: {
      Modification mod("dHex(1)Hex(1)HexNAc(3)Sulf(1)", "dHex Hex HexNAc(3) Sulf", 997.305665, 997.922600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1623: {
      Modification mod("Hex(2)HexA(1)NeuAc(1)Pent(1)Sulf(1)", "Hex(2) HexA NeuAc Pent Sulf", 1003.232225, 1003.837700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1624: {
      Modification mod("dHex(1)Hex(1)HexNAc(2)NeuAc(1)", "dHex Hex HexNAc(2) NeuAc", 1005.364894, 1005.921400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1625: {
      Modification mod("dHex(1)Hex(3)HexA(1)HexNAc(1)", "dHex Hex(3) HexA HexNAc", 1011.327840, 1011.879600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1626: {
      Modification mod("Hex(2)HexNAc(3)Sulf(1)", "Hex(2) HexNAc(3) Sulf", 1013.300579, 1013.922000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1627: {
      Modification mod("Hex(5)HexNAc(1)", "Hex(5) HexNAc", 1013.343490, 1013.895500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1628: {
      Modification mod("HexNAc(5)", "HexNAc(5)", 1015.396863, 1015.962600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1630: {
      Modification mod("Hex(1)HexNAc(1)NeuAc(2)Ac(2)", "Ac(2) Hex HexNAc NeuAc(2)", 1031.344159, 1031.915600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1631: {
      Modification mod("Hex(2)HexNAc(2)NeuGc(1)", "Hex(2) HexNAc(2) NeuGc", 1037.354723, 1037.920200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1632: {
      Modification mod("Hex(5)Phos(3)", "Hex(5) Phos(3)", 1050.163110, 1050.642700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1633: {
      Modification mod("Hex(6)Phos(1)", "Hex(6) Phos", 1052.283272, 1052.823500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1634: {
      Modification mod("dHex(1)Hex(2)HexA(1)HexNAc(2)", "dHex Hex(2) HexA HexNAc(2)", 1052.354389, 1052.931600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1635: {
      Modification mod("dHex(2)Hex(3)HexNAc(1)Sulf(1)", "dHex(2) Hex(3) HexNAc Sulf", 1061.310475, 1061.959900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1636: {
      Modification mod("Hex(1)HexNAc(3)NeuAc(1)", "Hex HexNAc(3) NeuAc", 1062.386358, 1062.972700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1637: {
      Modification mod("dHex(2)Hex(1)HexNAc(3)", "dHex(2) Hex HexNAc(3)", 1063.406759, 1064.000600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1638: {
      Modification mod("Hex(1)HexNAc(3)NeuGc(1)", "Hex HexNAc(3) NeuGc", 1078.381273, 1078.972100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1639: {
      Modification mod("dHex(1)Hex(1)HexNAc(2)NeuAc(1)Sulf(1)", "dHex Hex HexNAc(2) NeuAc Sulf", 1085.321709, 1085.984600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1640: {
      Modification mod("dHex(1)Hex(3)HexA(1)HexNAc(1)Sulf(1)", "dHex Hex(3) HexA HexNAc Sulf", 1091.284655, 1091.942800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1641: {
      Modification mod("dHex(1)Hex(1)HexA(1)HexNAc(3)", "dHex Hex HexA HexNAc(3)", 1093.380938, 1093.983500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1642: {
      Modification mod("Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "Hex(2) HexNAc(2) NeuAc Sulf", 1101.316623, 1101.984000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1643: {
      Modification mod("dHex(2)Hex(2)HexNAc(2)Sulf(1)", "dHex(2) Hex(2) HexNAc(2) Sulf", 1102.337025, 1103.011800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1644: {
      Modification mod("dHex(2)Hex(1)HexNAc(2)Kdn(1)", "dHex(2) Hex HexNAc(2) Kdn ---OR--- Hex(2) HexNAc dHex(2) NeuAc", 1110.396254, 1111.010700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1645: {
      Modification mod("dHex(1)Hex(1)HexNAc(4)", "dHex Hex HexNAc(4)", 1120.428223, 1121.051900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1646: {
      Modification mod("Hex(2)HexNAc(4)", "Hex(2) HexNAc(4)", 1136.423137, 1137.051300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1647: {
      Modification mod("Hex(2)HexNAc(1)NeuGc(2)", "Hex(2) HexNAc NeuGc(2)", 1141.365682, 1141.981700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1648: {
      Modification mod("dHex(2)Hex(4)HexNAc(1)", "dHex(2) Hex(4) HexNAc", 1143.406484, 1144.037300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1649: {
      Modification mod("Hex(1)HexNAc(2)NeuAc(2)", "Hex HexNAc(2) NeuAc(2)", 1150.402402, 1151.034800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1650: {
      Modification mod("dHex(2)Hex(1)HexNAc(2)NeuAc(1)", "dHex(2) Hex HexNAc(2) NeuAc", 1151.422803, 1152.062600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1651: {
      Modification mod("dHex(1)Hex(2)HexNAc(3)Sulf(1)", "dHex Hex(2) HexNAc(3) Sulf", 1159.358488, 1160.063200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1652: {
      Modification mod("dHex(1)HexNAc(5)", "dHex HexNAc(5)", 1161.454772, 1162.103800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1653: {
      Modification mod("dHex(2)Hex(1)HexNAc(2)NeuGc(1)", "dHex(2) Hex HexNAc(2) NeuGc ---OR--- Hex(2) HexNAc(2) dHex NeuAc ---OR--- Hex HexNAc(3) dHex Kdn", 1167.417718, 1168.062000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1654: {
      Modification mod("dHex(3)Hex(2)HexNAc(2)", "dHex(3) Hex(2) HexNAc(2)", 1168.438119, 1169.089800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1655: {
      Modification mod("Hex(3)HexNAc(3)Sulf(1)", "Hex(3) HexNAc(3) Sulf", 1175.353403, 1176.062600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1656: {
      Modification mod("dHex(2)Hex(2)HexNAc(2)Sulf(2)", "dHex(2) Hex(2) HexNAc(2) Sulf(2)", 1182.293839, 1183.075000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1657: {
      Modification mod("dHex(1)Hex(2)HexNAc(2)NeuGc(1)", "dHex Hex(2) HexNAc(2) NeuGc ---OR--- Hex(3) HexNAc(2) NeuAc", 1183.412632, 1184.061400);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1658: {
      Modification mod("dHex(1)Hex(1)HexNAc(3)NeuAc(1)", "dHex Hex HexNAc(3) NeuAc", 1208.444267, 1209.113900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1659: {
      Modification mod("Hex(6)Phos(3)", "Hex(6) Phos(3)", 1212.215934, 1212.783300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1660: {
      Modification mod("dHex(1)Hex(3)HexA(1)HexNAc(2)", "dHex Hex(3) HexA HexNAc(2)", 1214.407213, 1215.072200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1661: {
      Modification mod("dHex(1)Hex(1)HexNAc(3)NeuGc(1)", "dHex Hex HexNAc(3) NeuGc ---OR--- Hex(2) HexNAc(3) NeuAc", 1224.439181, 1225.113300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1662: {
      Modification mod("Hex(1)HexNAc(2)NeuAc(2)Sulf(1)", "Hex HexNAc(2) NeuAc(2) Sulf", 1230.359217, 1231.098000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1663: {
      Modification mod("dHex(2)Hex(3)HexA(1)HexNAc(1)Sulf(1)", "dHex(2) Hex(3) HexA HexNAc Sulf", 1237.342563, 1238.084000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1664: {
      Modification mod("Hex(1)HexNAc(1)NeuAc(3)", "Hex HexNAc NeuAc(3)", 1238.418446, 1239.096900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1665: {
      Modification mod("Hex(2)HexNAc(3)NeuGc(1)", "Hex(2) HexNAc(3) NeuGc", 1240.434096, 1241.112700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1666: {
      Modification mod("dHex(1)Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "dHex Hex(2) HexNAc(2) NeuAc Sulf", 1247.374532, 1248.125200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1667: {
      Modification mod("dHex(3)Hex(1)HexNAc(2)Kdn(1)", "dHex(3) Hex HexNAc(2) Kdn", 1256.454163, 1257.151900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1668: {
      Modification mod("dHex(2)Hex(3)HexNAc(2)Sulf(1)", "dHex(2) Hex(3) HexNAc(2) Sulf", 1264.389848, 1265.152400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1669: {
      Modification mod("dHex(2)Hex(2)HexNAc(2)Kdn(1)", "dHex(2) Hex(2) HexNAc(2) Kdn", 1272.449077, 1273.151300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1670: {
      Modification mod("dHex(2)Hex(2)HexA(1)HexNAc(2)Sulf(1)", "dHex(2) Hex(2) HexA HexNAc(2) Sulf", 1278.369113, 1279.136000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1671: {
      Modification mod("dHex(1)Hex(2)HexNAc(4)", "dHex Hex(2) HexNAc(4)", 1282.481046, 1283.192500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1672: {
      Modification mod("Hex(1)HexNAc(1)NeuGc(3)", "Hex HexNAc NeuGc(3)", 1286.403190, 1287.095100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1673: {
      Modification mod("dHex(1)Hex(1)HexNAc(3)NeuAc(1)Sulf(1)", "dHex Hex HexNAc(3) NeuAc Sulf", 1288.401081, 1289.177100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1674: {
      Modification mod("dHex(1)Hex(3)HexA(1)HexNAc(2)Sulf(1)", "dHex Hex(3) HexA HexNAc(2) Sulf", 1294.364027, 1295.135400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1675: {
      Modification mod("dHex(1)Hex(1)HexNAc(2)NeuAc(2)", "dHex Hex HexNAc(2) NeuAc(2)", 1296.460311, 1297.176000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1676: {
      Modification mod("dHex(3)HexNAc(3)Kdn(1)", "dHex(3) HexNAc(3) Kdn", 1297.480712, 1298.203800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1678: {
      Modification mod("Hex(2)HexNAc(3)NeuAc(1)Sulf(1)", "Hex(2) HexNAc(3) NeuAc Sulf", 1304.395996, 1305.176500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1679: {
      Modification mod("dHex(2)Hex(2)HexNAc(3)Sulf(1)", "dHex(2) Hex(2) HexNAc(3) Sulf", 1305.416397, 1306.204400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1680: {
      Modification mod("dHex(2)HexNAc(5)", "dHex(2) HexNAc(5)", 1307.512681, 1308.245000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1681: {
      Modification mod("Hex(2)HexNAc(2)NeuAc(2)", "Hex(2) HexNAc(2) NeuAc(2)", 1312.455225, 1313.175400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1682: {
      Modification mod("dHex(2)Hex(2)HexNAc(2)NeuAc(1)", "dHex(2) Hex(2) HexNAc(2) NeuAc ---OR--- Hex HexNAc(3) dHex(2) Kdn", 1313.475627, 1314.203200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1683: {
      Modification mod("dHex(1)Hex(3)HexNAc(3)Sulf(1)", "dHex Hex(3) HexNAc(3) Sulf", 1321.411312, 1322.203800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1684: {
      Modification mod("dHex(2)Hex(2)HexNAc(2)NeuGc(1)", "dHex(2) Hex(2) HexNAc(2) NeuGc ---OR--- Hex(3) HexNAc(2) dHex NeuAc ---OR--- Hex(2) HexNAc(3) dHex Kdn", 1329.470541, 1330.202600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1685: {
      Modification mod("Hex(2)HexNAc(5)", "Hex(2) HexNAc(5)", 1339.502510, 1340.243800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1686: {
      Modification mod("dHex(1)Hex(3)HexNAc(2)NeuGc(1)", "dHex Hex(3) HexNAc(2) NeuGc", 1345.465456, 1346.202000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1687: {
      Modification mod("Hex(1)HexNAc(3)NeuAc(2)", "Hex HexNAc(3) NeuAc(2)", 1353.481775, 1354.227300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1688: {
      Modification mod("dHex(1)Hex(2)HexNAc(3)NeuAc(1)", "dHex Hex(2) HexNAc(3) NeuAc", 1370.497090, 1371.254500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1689: {
      Modification mod("dHex(3)Hex(2)HexNAc(3)", "dHex(3) Hex(2) HexNAc(3)", 1371.517491, 1372.282400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1690: {
      Modification mod("Hex(7)Phos(3)", "Hex(7) Phos(3)", 1374.268757, 1374.923900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1691: {
      Modification mod("dHex(1)Hex(4)HexA(1)HexNAc(2)", "dHex Hex(4) HexA HexNAc(2)", 1376.460036, 1377.212800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1692: {
      Modification mod("Hex(3)HexNAc(3)NeuAc(1)", "Hex(3) HexNAc(3) NeuAc ---OR--- Hex(2) HexNAc(3) dHex NeuGc ---OR--- Hex(2) HexNAc(4) Kdn", 1386.492005, 1387.253900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1693: {
      Modification mod("dHex(1)Hex(3)HexA(2)HexNAc(2)", "dHex Hex(3) HexA(2) HexNAc(2)", 1390.439301, 1391.196300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1694: {
      Modification mod("Hex(2)HexNAc(2)NeuAc(2)Sulf(1)", "Hex(2) HexNAc(2) NeuAc(2) Sulf", 1392.412040, 1393.238600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1695: {
      Modification mod("dHex(2)Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "dHex(2) Hex(2) HexNAc(2) NeuAc Sulf", 1393.432441, 1394.266400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1696: {
      Modification mod("Hex(3)HexNAc(3)NeuGc(1)", "Hex(3) HexNAc(3) NeuGc", 1402.486920, 1403.253300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1697: {
      Modification mod("dHex(4)Hex(1)HexNAc(2)Kdn(1)", "dHex(4) Hex HexNAc(2) Kdn", 1402.512072, 1403.293100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1698: {
      Modification mod("dHex(3)Hex(2)HexNAc(2)Kdn(1)", "dHex(3) Hex(2) HexNAc(2) Kdn", 1418.506986, 1419.292500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1699: {
      Modification mod("dHex(3)Hex(2)HexA(1)HexNAc(2)Sulf(1)", "dHex(3) Hex(2) HexA HexNAc(2) Sulf", 1424.427021, 1425.277200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1700: {
      Modification mod("Hex(2)HexNAc(4)NeuAc(1)", "Hex(2) HexNAc(4) NeuAc", 1427.518554, 1428.305900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1701: {
      Modification mod("dHex(2)Hex(2)HexNAc(4)", "dHex(2) Hex(2) HexNAc(4)", 1428.538955, 1429.333700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1702: {
      Modification mod("dHex(2)Hex(3)HexA(1)HexNAc(2)Sulf(1)", "dHex(2) Hex(3) HexA HexNAc(2) Sulf", 1440.421936, 1441.276600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1703: {
      Modification mod("dHex(4)HexNAc(3)Kdn(1)", "dHex(4) HexNAc(3) Kdn", 1443.538621, 1444.345000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1705: {
      Modification mod("Hex(2)HexNAc(1)NeuGc(3)", "Hex(2) HexNAc NeuGc(3)", 1448.456013, 1449.235700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1706: {
      Modification mod("dHex(4)Hex(1)HexNAc(1)Kdn(2)", "dHex(4) Hex HexNAc Kdn(2)", 1449.501567, 1450.303200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1707: {
      Modification mod("dHex(1)Hex(2)HexNAc(3)NeuAc(1)Sulf(1)", "dHex Hex(2) HexNAc(3) NeuAc Sulf", 1450.453905, 1451.317700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1708: {
      Modification mod("dHex(1)Hex(2)HexNAc(2)NeuAc(2)", "dHex Hex(2) HexNAc(2) NeuAc(2)", 1458.513134, 1459.316600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1709: {
      Modification mod("dHex(3)Hex(1)HexNAc(3)Kdn(1)", "dHex(3) Hex HexNAc(3) Kdn", 1459.533535, 1460.344400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1711: {
      Modification mod("Hex(3)HexNAc(3)NeuAc(1)Sulf(1)", "Hex(3) HexNAc(3) NeuAc Sulf", 1466.448820, 1467.317100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1712: {
      Modification mod("Hex(3)HexNAc(2)NeuAc(2)", "Hex(3) HexNAc(2) NeuAc(2)", 1474.508049, 1475.316000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1713: {
      Modification mod("Hex(3)HexNAc(3)NeuGc(1)Sulf(1)", "Hex(3) HexNAc(3) NeuGc Sulf", 1482.443734, 1483.316500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1714: {
      Modification mod("dHex(1)Hex(2)HexNAc(2)NeuGc(2)", "dHex Hex(2) HexNAc(2) NeuGc(2)", 1490.502964, 1491.315400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1715: {
      Modification mod("dHex(2)Hex(3)HexNAc(2)NeuGc(1)", "dHex(2) Hex(3) HexNAc(2) NeuGc ---OR--- Hex(4) HexNAc(2) dHex NeuAc", 1491.523365, 1492.343200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1716: {
      Modification mod("dHex(1)Hex(3)HexA(1)HexNAc(3)Sulf(1)", "dHex Hex(3) HexA HexNAc(3) Sulf", 1497.443400, 1498.327900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1717: {
      Modification mod("Hex(2)HexNAc(3)NeuAc(2)", "Hex(2) HexNAc(3) NeuAc(2)", 1515.534598, 1516.367900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1718: {
      Modification mod("dHex(2)Hex(2)HexNAc(3)NeuAc(1)", "dHex(2) Hex(2) HexNAc(3) NeuAc", 1516.554999, 1517.395700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1719: {
      Modification mod("dHex(4)Hex(2)HexNAc(3)", "dHex(4) Hex(2) HexNAc(3)", 1517.575400, 1518.423600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1720: {
      Modification mod("Hex(2)HexNAc(3)NeuAc(1)NeuGc(1)", "Hex(2) HexNAc(3) NeuAc NeuGc", 1531.529513, 1532.367300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1721: {
      Modification mod("dHex(2)Hex(2)HexNAc(3)NeuGc(1)", "dHex(2) Hex(2) HexNAc(3) NeuGc ---OR--- Hex(3) HexNAc(3) dHex NeuAc ---OR--- Hex(2) HexNAc(4) dHex Kdn", 1532.549914, 1533.395100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1722: {
      Modification mod("dHex(3)Hex(3)HexNAc(3)", "dHex(3) Hex(3) HexNAc(3)", 1533.570315, 1534.423000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1723: {
      Modification mod("Hex(8)Phos(3)", "Hex(8) Phos(3)", 1536.321581, 1537.064500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1724: {
      Modification mod("dHex(1)Hex(2)HexNAc(2)NeuAc(2)Sulf(1)", "dHex Hex(2) HexNAc(2) NeuAc(2) Sulf", 1538.469949, 1539.379800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1725: {
      Modification mod("Hex(2)HexNAc(3)NeuGc(2)", "Hex(2) HexNAc(3) NeuGc(2)", 1547.524427, 1548.366700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1726: {
      Modification mod("dHex(4)Hex(2)HexNAc(2)Kdn(1)", "dHex(4) Hex(2) HexNAc(2) Kdn", 1564.564895, 1565.433700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1727: {
      Modification mod("dHex(1)Hex(2)HexNAc(4)NeuAc(1)", "dHex Hex(2) HexNAc(4) NeuAc", 1573.576463, 1574.447100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1728: {
      Modification mod("dHex(3)Hex(2)HexNAc(4)", "dHex(3) Hex(2) HexNAc(4)", 1574.596864, 1575.474900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1729: {
      Modification mod("Hex(1)HexNAc(1)NeuGc(4)", "Hex HexNAc NeuGc(4)", 1593.493521, 1594.349000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1730: {
      Modification mod("dHex(4)Hex(1)HexNAc(3)Kdn(1)", "dHex(4) Hex HexNAc(3) Kdn", 1605.591444, 1606.485600);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1732: {
      Modification mod("Hex(4)HexNAc(4)Sulf(2)", "Hex(4) HexNAc(4) Sulf(2)", 1620.442414, 1621.458900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1733: {
      Modification mod("dHex(3)Hex(2)HexNAc(3)Kdn(1)", "dHex(3) Hex(2) HexNAc(3) Kdn ---OR--- Hex(3) HexNAc(2) dHex(3) NeuAc", 1621.586359, 1622.485000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1735: {
      Modification mod("dHex(2)Hex(2)HexNAc(5)", "dHex(2) Hex(2) HexNAc(5)", 1631.618328, 1632.526200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1736: {
      Modification mod("dHex(2)Hex(3)HexA(1)HexNAc(3)Sulf(1)", "dHex(2) Hex(3) HexA HexNAc(3) Sulf", 1643.501309, 1644.469100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1737: {
      Modification mod("dHex(1)Hex(4)HexA(1)HexNAc(3)Sulf(1)", "dHex Hex(4) HexA HexNAc(3) Sulf", 1659.496223, 1660.468500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1738: {
      Modification mod("Hex(3)HexNAc(3)NeuAc(2)", "Hex(3) HexNAc(3) NeuAc(2)", 1677.587422, 1678.508500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1739: {
      Modification mod("dHex(2)Hex(3)HexNAc(3)NeuAc(1)", "dHex(2) Hex(3) HexNAc(3) NeuAc ---OR--- Hex(2) HexNAc(4) dHex(2) Kdn", 1678.607823, 1679.536300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1740: {
      Modification mod("dHex(4)Hex(3)HexNAc(3)", "dHex(4) Hex(3) HexNAc(3)", 1679.628224, 1680.564200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1742: {
      Modification mod("Hex(9)Phos(3)", "Hex(9) Phos(3)", 1698.374404, 1699.205100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1743: {
      Modification mod("dHex(2)HexNAc(7)", "dHex(2) HexNAc(7)", 1713.671426, 1714.630000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1744: {
      Modification mod("Hex(2)HexNAc(1)NeuGc(4)", "Hex(2) HexNAc NeuGc(4)", 1755.546345, 1756.489600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1745: {
      Modification mod("Hex(3)HexNAc(3)NeuAc(2)Sulf(1)", "Hex(3) HexNAc(3) NeuAc(2) Sulf", 1757.544236, 1758.571700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1746: {
      Modification mod("dHex(2)Hex(3)HexNAc(5)", "dHex(2) Hex(3) HexNAc(5)", 1793.671151, 1794.666800);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1747: {
      Modification mod("dHex(1)Hex(2)HexNAc(2)NeuGc(3)", "dHex Hex(2) HexNAc(2) NeuGc(3)", 1797.593295, 1798.569400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1748: {
      Modification mod("dHex(2)Hex(4)HexA(1)HexNAc(3)Sulf(1)", "dHex(2) Hex(4) HexA HexNAc(3) Sulf", 1805.554132, 1806.609700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1749: {
      Modification mod("Hex(2)HexNAc(3)NeuAc(3)", "Hex(2) HexNAc(3) NeuAc(3)", 1806.630015, 1807.622500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1750: {
      Modification mod("dHex(1)Hex(3)HexNAc(3)NeuAc(2)", "dHex Hex(3) HexNAc(3) NeuAc(2)", 1823.645330, 1824.649700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1751: {
      Modification mod("dHex(3)Hex(3)HexNAc(3)NeuAc(1)", "dHex(3) Hex(3) HexNAc(3) NeuAc", 1824.665732, 1825.677500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1752: {
      Modification mod("Hex(2)HexNAc(3)NeuGc(3)", "Hex(2) HexNAc(3) NeuGc(3)", 1854.614759, 1855.620700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1753: {
      Modification mod("Hex(10)Phos(3)", "Hex(10) Phos(3)", 1860.427228, 1861.345700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1754: {
      Modification mod("dHex(1)Hex(2)HexNAc(4)NeuAc(2)", "dHex Hex(2) HexNAc(4) NeuAc(2)", 1864.671880, 1865.701600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1755: {
      Modification mod("Hex(1)HexNAc(1)NeuGc(5)", "Hex HexNAc NeuGc(5)", 1900.583852, 1901.603000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1756: {
      Modification mod("Hex(4)HexNAc(4)NeuAc(1)Sulf(2)", "Hex(4) HexNAc(4) NeuAc Sulf(2)", 1911.537830, 1912.713500);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1757: {
      Modification mod("Hex(4)HexNAc(4)NeuGc(1)Sulf(2)", "Hex(4) HexNAc(4) NeuGc Sulf(2)", 1927.532745, 1928.712900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1758: {
      Modification mod("dHex(2)Hex(3)HexNAc(3)NeuAc(2)", "dHex(2) Hex(3) HexNAc(3) NeuAc(2)", 1969.703239, 1970.790900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1759: {
      Modification mod("Hex(4)HexNAc(4)NeuAc(1)Sulf(3)", "Hex(4) HexNAc(4) NeuAc Sulf(3)", 1991.494645, 1992.776700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1760: {
      Modification mod("dHex(2)Hex(2)HexNAc(2)", "dHex(2) Hex(2) HexNAc(2)", 1022.380210, 1022.948600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1761: {
      Modification mod("dHex(1)Hex(3)HexNAc(2)", "dHex Hex(3) HexNAc(2)", 1038.375125, 1038.948000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1762: {
      Modification mod("dHex(1)Hex(2)HexNAc(3)", "dHex Hex(2) HexNAc(3)", 1079.401674, 1080.000000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1763: {
      Modification mod("Hex(3)HexNAc(3)", "Hex(3) HexNAc(3)", 1095.396588, 1095.999400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1764: {
      Modification mod("dHex(1)Hex(3)HexNAc(2)Sulf(1)", "dHex Hex(3) HexNAc(2) Sulf", 1118.331939, 1119.011200);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1765: {
      Modification mod("dHex(2)Hex(3)HexNAc(2)", "dHex(2) Hex(3) HexNAc(2)", 1184.433033, 1185.089200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1766: {
      Modification mod("dHex(1)Hex(4)HexNAc(2)", "dHex Hex(4) HexNAc(2)", 1200.427948, 1201.088600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1767: {
      Modification mod("dHex(2)Hex(2)HexNAc(3)", "dHex(2) Hex(2) HexNAc(3)", 1225.459583, 1226.141200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1768: {
      Modification mod("dHex(1)Hex(3)HexNAc(3)", "dHex Hex(3) HexNAc(3)", 1241.454497, 1242.140600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1769: {
      Modification mod("Hex(4)HexNAc(3)", "Hex(4) HexNAc(3)", 1257.449412, 1258.140000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1770: {
      Modification mod("dHex(2)Hex(4)HexNAc(2)", "dHex(2) Hex(4) HexNAc(2)", 1346.485857, 1347.229800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1771: {
      Modification mod("dHex(2)Hex(3)HexNAc(3)", "dHex(2) Hex(3) HexNAc(3)", 1387.512406, 1388.281800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1772: {
      Modification mod("Hex(3)HexNAc(5)", "A3", 1501.555334, 1502.384400);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1773: {
      Modification mod("Hex(4)HexNAc(3)NeuAc(1)", "Hex(4) HexNAc(3) NeuAc ---OR--- Hex(3) HexNAc(4) Kdn", 1548.544828, 1549.394500);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1774: {
      Modification mod("dHex(2)Hex(3)HexNAc(4)", "dHex(2) Hex(3) HexNAc(4)", 1590.591779, 1591.474300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1775: {
      Modification mod("dHex(1)Hex(3)HexNAc(5)", "dHex Hex(3) HexNAc(5)", 1647.613242, 1648.525600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1776: {
      Modification mod("Hex(3)HexNAc(6)", "A4", 1704.634706, 1705.576900);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1777: {
      Modification mod("Hex(4)HexNAc(4)NeuAc(1)", "Hex(4) HexNAc(4) NeuAc", 1751.624201, 1752.587100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1778: {
      Modification mod("dHex(2)Hex(4)HexNAc(4)", "dHex(2) Hex(4) HexNAc(4) ---OR--- Hex(4) HexNAc(4) dHex Pent Me", 1752.644602, 1753.614900);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1779: {
      Modification mod("Hex(6)HexNAc(4)", "Hex(6) HexNAc(4)", 1784.634431, 1785.613700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1780: {
      Modification mod("Hex(5)HexNAc(5)", "Hex(5) HexNAc(5)", 1825.660981, 1826.665600);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1781: {
      Modification mod("dHex(1)Hex(3)HexNAc(6)", "dHex Hex(3) HexNAc(6)", 1850.692615, 1851.718100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1782: {
      Modification mod("dHex(1)Hex(4)HexNAc(4)NeuAc(1)", "dHex Hex(4) HexNAc(4) NeuAc ---OR--- Hex(3) HexNAc(5) dHex Kdn", 1897.682110, 1898.728300);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1783: {
      Modification mod("dHex(3)Hex(4)HexNAc(4)", "dHex(3) Hex(4) HexNAc(4)", 1898.702511, 1899.756100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1784: {
      Modification mod("dHex(1)Hex(3)HexNAc(5)NeuAc(1)", "dHex Hex(3) HexNAc(5) NeuAc", 1938.708659, 1939.780200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1785: {
      Modification mod("dHex(2)Hex(4)HexNAc(5)", "dHex(2) Hex(4) HexNAc(5)", 1955.723975, 1956.807400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1799: {
      Modification mod("NQIGG", "SUMOylation by Giardia lamblia", 469.228496, 469.492100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1800: {
      Modification mod("Carboxyethylpyrrole", "Carboxyethylpyrrole", 122.036779, 122.121300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1801: {
      Modification mod("Fluorescein-tyramine", "Fluorescein-tyramine adduct by peroxidase activity", 493.116152, 493.463700);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1840: {
      Modification mod("dHex(1)Hex(7)HexNAc(4)", "Fucosylated biantennary + 2 alphaGal", 2092.745164, 2093.895500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1839: {
      Modification mod("betaFNA", "beta-Funaltrexamine", 454.210387, 454.515500);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1838: {
      Modification mod("Brij58", "Brij 58 synthetic polymer terminus", 224.250401, 224.425300);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1837: {
      Modification mod("Brij35", "Brij 35 synthetic polymer terminus", 168.187801, 168.319000);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1836: {
      Modification mod("Triton", "Triton synthetic polymer terminus", 188.156501, 188.308600);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 1835: {
      Modification mod("Tween80", "Tween 80 synthetic polymer terminus", 263.237491, 263.438100);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 1834: {
      Modification mod("Tween20", "Tween 20 synthetic polymer terminus", 165.164326, 165.295100);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1831: {
      Modification mod("Tris", "tris adduct causes 104 Da addition at asparagine-succinimide intermediate", 104.071154, 104.127700);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1830: {
      Modification mod("Biotin-tyramide", "Biotin-Phenol", 361.146012, 361.458500);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1829: {
      Modification mod("LRGG+dimethyl", "LeudimethylArgGlyGly", 411.259403, 411.499100);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1825: {
      Modification mod("RNPXL", "Simulate peptide-RNA conjugates", 324.035867, 324.181300);
      mod.addSpecificity('R', ANY_N);
      mod.addSpecificity('K', ANY_N);
      return mod;
    }
    case 1824: {
      Modification mod("GEE", "transamidation of glycine ethyl ester to glutamine", 86.036779, 86.089200);
      mod.addSpecificity('Q', ANYWHERE);
      return mod;
    }
    case 1826: {
      Modification mod("Glu->pyro-Glu+Methyl", "Pyro-Glu from E + Methylation", -3.994915, -3.988700);
      mod.addSpecificity('E', ANY_N);
      return mod;
    }
    case 1827: {
      Modification mod("Glu->pyro-Glu+Methyl:2H(2)13C(1)", "Pyro-Glu from E + Methylation Medium", -0.979006, -0.983700);
      mod.addSpecificity('E', ANY_N);
      return mod;
    }
    case 1828: {
      Modification mod("LRGG+methyl", "LeumethylArgGlyGly", 397.243753, 397.472500);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1833: {
      Modification mod("NP40", "NP-40 synthetic polymer terminus", 220.182715, 220.350500);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1832: {
      Modification mod("IASD", "Iodoacetamide derivative of stilbene (reaction product with thiol)", 452.034807, 452.458200);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1841: {
      Modification mod("Biotin:Thermo-21328", "EZ-Link Sulfo-NHS-SS-Biotin", 389.090154, 389.556400);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1843: {
      Modification mod("PhosphoCytidine", "Cytidine monophosphate", 305.041287, 305.181200);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1845: {
      Modification mod("AzidoF", "Azidophenylalanine", 41.001397, 41.012200);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 1846: {
      Modification mod("Dimethylaminoethyl", "Cys alkylation by dimethylaminoethyl halide", 71.073499, 71.121000);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1848: {
      Modification mod("Gluratylation", "Glutarylation", 114.031694, 114.099300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1849: {
      Modification mod("hydroxyisobutyryl", "2-hydroxyisobutyrylation", 86.036779, 86.089200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1868: {
      Modification mod("MeMePhosphorothioate", "S-Methyl Methyl phosphorothioate", 107.979873, 108.099300);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1870: {
      Modification mod("Cation:Fe[III]", "Replacement of 3 protons by iron", 52.911464, 52.821200);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 1871: {
      Modification mod("DTT", "DTT adduct of cysteine", 151.996571, 152.235100);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1872: {
      Modification mod("DYn-2", "Sulfenic Acid specific probe", 161.096640, 161.220300);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1878: {
      Modification mod("Xlink:DSSO[176]", "Water-quenched monolink of DSSO crosslinker", 176.014330, 176.190300);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1873: {
      Modification mod("MesitylOxide", "Acetone chemical artifact", 98.073165, 98.143000);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1877: {
      Modification mod("Xlink:DSS[259]", "Tris-quenched monolink of DSS/BS3 crosslinker", 259.141973, 259.298800);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1875: {
      Modification mod("methylol", "formaldehyde induced modifications", 30.010565, 30.026000);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('W', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1879: {
      Modification mod("Xlink:DSSO[175]", "Ammonia-quenched monolink of DSSO crosslinker", 175.030314, 175.205600);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1880: {
      Modification mod("Xlink:DSSO[279]", "Tris-quenched monolink of DSSO crosslinker", 279.077658, 279.310100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1881: {
      Modification mod("Xlink:DSSO[54]", "Alkene fragment of DSSO crosslinker", 54.010565, 54.047400);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1882: {
      Modification mod("Xlink:DSSO[86]", "Thiol fragment of DSSO crosslinker", 85.982635, 86.112400);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1883: {
      Modification mod("Xlink:DSSO[104]", "Sulfenic acid fragment of DSSO crosslinker", 103.993200, 104.127700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1885: {
      Modification mod("Xlink:BuUrBu[111]", "BuUr fragment of BuUrBu crosslinker", 111.032028, 111.098700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1886: {
      Modification mod("Xlink:BuUrBu[85]", "Bu fragment of BuUrBu crosslinker", 85.052764, 85.104500);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1888: {
      Modification mod("Xlink:BuUrBu[214]", "Water quenched monolink of BuUrBu crosslinker", 214.095357, 214.218500);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1889: {
      Modification mod("Xlink:BuUrBu[317]", "Tris quenched monolink of BuUrBu crosslinker", 317.158686, 317.338200);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1896: {
      Modification mod("Xlink:DSSO[158]", "Intact DSSO crosslinker", 158.003765, 158.175000);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1898: {
      Modification mod("Xlink:DSS[138]", "Intact DSS/BS3 crosslinker", 138.068080, 138.163800);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1899: {
      Modification mod("Xlink:BuUrBu[196]", "Intact BuUrBu crosslinker", 196.084792, 196.203200);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1900: {
      Modification mod("Xlink:DTBP[172]", "Intact DTBP crosslinker", 172.012890, 172.271100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1901: {
      Modification mod("Xlink:DST[114]", "Intact DST crosslinker", 113.995309, 114.056300);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1902: {
      Modification mod("Xlink:DTSSP[174]", "Intact DSP/DTSSP crosslinker", 173.980921, 174.240600);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1903: {
      Modification mod("Xlink:SMCC[219]", "Intact SMCC cross-link", 219.089543, 219.236500);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1910: {
      Modification mod("Cation:Al[III]", "Replacement of 3 protons by aluminium", 23.958063, 23.957700);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 1906: {
      Modification mod("Xlink:BS2G[113]", "Ammonium-quenched monolink of BS2-G crosslinker", 113.047679, 113.114600);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1907: {
      Modification mod("Xlink:BS2G[114]", "Water-quenched monolink of BS2-G crosslinker", 114.031694, 114.099300);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1908: {
      Modification mod("Xlink:BS2G[217]", "Tris-quenched monolink of BS2-G crosslinker", 217.095023, 217.219100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1911: {
      Modification mod("Xlink:DMP[139]", "Ammonia quenched monolink of DMP crosslinker", 139.110947, 139.198200);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1912: {
      Modification mod("Xlink:DMP[122]", "Intact DMP crosslinker", 122.084398, 122.167700);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 1913: {
      Modification mod("glyoxalAGE", "glyoxal-derived AGE", 21.984350, 22.005500);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1914: {
      Modification mod("Met->AspSA", "Methionine oxidation to aspartic semialdehyde", -32.008456, -32.108100);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 1915: {
      Modification mod("Decarboxylation", "Decarboxylation", -30.010565, -30.026000);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 1916: {
      Modification mod("Aspartylurea", "Aspartylurea", -10.031969, -10.041200);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1917: {
      Modification mod("Formylasparagine", "In Bachi as Formylaspargine (typo?)", 4.978930, 4.973500);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 1918: {
      Modification mod("Carbonyl", "aldehyde and ketone modifications", 13.979265, 13.983500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('Q', ANYWHERE);
      mod.addSpecificity('L', ANYWHERE);
      mod.addSpecificity('I', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('A', ANYWHERE);
      mod.addSpecificity('V', ANYWHERE);
      return mod;
    }
    case 1922: {
      Modification mod("Pro->HAVA", "Proline oxidation to 5-hydroxy-2-aminovaleric acid", 18.010565, 18.015300);
      mod.addSpecificity('P', ANYWHERE);
      return mod;
    }
    case 1920: {
      Modification mod("AFB1_Dialdehyde", "adduction of aflatoxin B1 Dialdehyde to lysine", 310.047738, 310.257700);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1923: {
      Modification mod("Delta:H(-4)O(2)", "Tryptophan oxidation to beta-unsaturated-2,4-bis-tryptophandione", 27.958529, 27.967000);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1924: {
      Modification mod("Delta:H(-4)O(3)", "Tryptophan oxidation to hydroxy-bis-tryptophandione", 43.953444, 43.966400);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1925: {
      Modification mod("Delta:O(4)", "Tryptophan oxidation to dihydroxy-N-formaylkynurenine", 63.979659, 63.997600);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 1926: {
      Modification mod("Delta:H(4)C(3)O(2)", "methylglyoxal-derived carboxyethyllysine", 72.021129, 72.062700);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1927: {
      Modification mod("Delta:H(4)C(5)O(1)", "methylglyoxal-derived argpyrimidine", 80.026215, 80.084700);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1928: {
      Modification mod("Delta:H(10)C(8)O(1)", "crotonaldehyde-derived dimethyl-FDP-lysine", 122.073165, 122.164400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1929: {
      Modification mod("Delta:H(6)C(7)O(4)", "methylglyoxal-derived tetrahydropyrimidine", 154.026609, 154.120100);
      mod.addSpecificity('R', ANYWHERE);
      return mod;
    }
    case 1932: {
      Modification mod("Hex(2)Sulf(1)", "Hex(2) O(3) S", 404.062462, 404.344400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1930: {
      Modification mod("Pent(2)", "Pent(2)", 264.084518, 264.229200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1931: {
      Modification mod("Pent(1)HexNAc(1)", "Pent HexNAc", 335.121631, 335.307100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1933: {
      Modification mod("Hex(1)Pent(2)Me(1)", "Hex:1 Pent:2 Me:1", 440.152991, 440.396400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1934: {
      Modification mod("HexNAc(2)Sulf(1)", "HexNAc(2) Sulf", 486.115560, 486.448200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1935: {
      Modification mod("Hex(1)Pent(3)Me(1)", "Hex Pent(3) Me", 572.195250, 572.511000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1936: {
      Modification mod("Hex(2)Pent(2)", "Hex(2) Pent(2)", 588.190165, 588.510400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1937: {
      Modification mod("Hex(2)Pent(2)Me(1)", "Hex(2) Pent(2) Me", 602.205815, 602.537000);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1938: {
      Modification mod("Hex(4)HexA(1)", "Hex(4) HexA", 824.243382, 824.686500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1939: {
      Modification mod("Hex(2)HexNAc(1)Pent(1)HexA(1)", "Hex(2) HexNAc Pent HexA", 835.259366, 835.712500);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1940: {
      Modification mod("Hex(3)HexNAc(1)HexA(1)", "Hex(3) HexNAc HexA", 865.269931, 865.738400);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1941: {
      Modification mod("Hex(1)HexNAc(2)dHex(2)Sulf(1)", "Hex HexNAc(2) dHex(2) Sulf", 940.284201, 940.871200);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1942: {
      Modification mod("HexA(2)HexNAc(3)", "HexA(2) HexNAc(3)", 961.302294, 961.825800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1943: {
      Modification mod("dHex(1)Hex(4)HexA(1)", "dHex Hex(4) HexA", 970.301291, 970.827700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1944: {
      Modification mod("Hex(5)HexA(1)", "Hex(5) HexA", 986.296206, 986.827100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1945: {
      Modification mod("Hex(4)HexA(1)HexNAc(1)", "Hex(4) HexA HexNAc", 1027.322755, 1027.879000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1946: {
      Modification mod("dHex(3)Hex(3)HexNAc(1)", "dHex(3) Hex(3) HexNAc", 1127.411570, 1128.037900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1947: {
      Modification mod("Hex(6)HexNAc(1)", "Hex(6) HexNAc", 1175.396314, 1176.036100);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1948: {
      Modification mod("Hex(1)HexNAc(4)dHex(1)Sulf(1)", "Sulf dHex Hex HexNAc(4)", 1200.385037, 1201.115100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1949: {
      Modification mod("dHex(1)Hex(2)HexNAc(1)NeuAc(2)", "dHex Hex(2) HexNAc NeuAc(2)", 1255.433762, 1256.124100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1950: {
      Modification mod("dHex(3)Hex(3)HexNAc(2)", "dHex(3) Hex(3) HexNAc(2)", 1330.490942, 1331.230400);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1951: {
      Modification mod("dHex(2)Hex(1)HexNAc(4)Sulf(1)", "dHex(2) Hex HexNAc(4) Sulf", 1346.442946, 1347.256300);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1952: {
      Modification mod("dHex(1)Hex(2)HexNAc(4)Sulf(2)", "dHex Hex(2) HexNAc(4) Sulf(2)", 1442.394675, 1443.318900);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1953: {
      Modification mod("Hex(9)", "Hex(9)", 1458.475412, 1459.265400);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1954: {
      Modification mod("dHex(2)Hex(3)HexNAc(3)Sulf(1)", "Sulf dHex(2) Hex(3) HexNAc(3)", 1467.469221, 1468.345000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1955: {
      Modification mod("dHex(2)Hex(5)HexNAc(2)Me(1)", "Me dHex(2) Hex(5) HexNAc(2)", 1522.554331, 1523.397000);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1956: {
      Modification mod("dHex(2)Hex(2)HexNAc(4)Sulf(2)", "Sulf(2) dHex(2) Hex(2) HexNAc(4)", 1588.452584, 1589.460100);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1957: {
      Modification mod("Hex(9)HexNAc(1)", "Hex(9) HexNAc", 1661.554784, 1662.457900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1958: {
      Modification mod("dHex(3)Hex(2)HexNAc(4)Sulf(2)", "dHex(3) Hex(2) HexNAc(4) Sulf(2)", 1734.510493, 1735.601300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1959: {
      Modification mod("Hex(4)HexNAc(4)NeuGc(1)", "Hex(4) HexNAc(4) NeuGc", 1767.619116, 1768.586500);
      mod.addSpecificity('N', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1960: {
      Modification mod("dHex(4)Hex(3)HexNAc(2)NeuAc(1)", "dHex(4) Hex(3) HexNAc(2) NeuAc(1)", 1767.644268, 1768.626200);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 1961: {
      Modification mod("Hex(3)HexNAc(5)NeuAc(1)", "Hex(3) HexNAc(5) NeuAc(1)", 1792.650750, 1793.639000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1962: {
      Modification mod("Hex(10)HexNAc(1)", "Hex(10) HexNAc(1)", 1823.607608, 1824.598500);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1963: {
      Modification mod("dHex(1)Hex(8)HexNAc(2)", "dHex Hex(8) HexNAc(2)", 1848.639242, 1849.651000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1964: {
      Modification mod("Hex(3)HexNAc(4)NeuAc(2)", "Hex(3) HexNAc(4) NeuAc(2)", 1880.666794, 1881.701000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1965: {
      Modification mod("dHex(2)Hex(3)HexNAc(4)NeuAc(1)", "dHex(2) Hex(3) HexNAc(4) NeuAc", 1881.687195, 1882.728900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1966: {
      Modification mod("dHex(2)Hex(2)HexNAc(6)Sulf(1)", "dHex(2) Hex(2) HexNAc(6) Sulf", 1914.654515, 1915.781900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1967: {
      Modification mod("Hex(5)HexNAc(4)NeuAc(1)Ac(1)", "Hex(5) HexNAc(4) NeuAc Ac", 1955.687589, 1956.764300);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1968: {
      Modification mod("Hex(3)HexNAc(3)NeuAc(3)", "Hex(3) HexNAc(3) NeuAc(3)", 1968.682838, 1969.763100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1969: {
      Modification mod("Hex(5)HexNAc(4)NeuAc(1)Ac(2)", "Hex(5) HexNAc(4) NeuAc Ac(2)", 1997.698154, 1998.801000);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 1970: {
      Modification mod("Unknown:162", "Unidentified modification of 162.1258 found in open search", 162.125595, 162.226700);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1971: {
      Modification mod("Unknown:177", "Unidentified modification of 176.7462 found in open search", 176.744957, 176.478800);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1972: {
      Modification mod("Unknown:210", "Unidentified modification of 210.1616 found in open search", 210.161980, 210.312600);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1973: {
      Modification mod("Unknown:216", "Unidentified modification of 216.1002 found in open search", 216.099774, 216.231000);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1974: {
      Modification mod("Unknown:234", "Unidentified modification of 234.0742 found in open search", 234.073953, 234.203300);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1975: {
      Modification mod("Unknown:248", "Unidentified modification of 248.1986 found in open search", 248.198760, 248.359000);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1976: {
      Modification mod("Unknown:250", "Unidentified modification of 249.981 found in open search", 249.981018, 250.207500);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1977: {
      Modification mod("Unknown:302", "Unidentified modification of 301.9864 found in open search", 301.986514, 302.265600);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1978: {
      Modification mod("Unknown:306", "Unidentified modification of 306.0952 found in open search", 306.095082, 306.265900);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('c', ANY_C);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 1979: {
      Modification mod("Unknown:420", "Unidentified modification of 420.0506 found in open search", 420.051719, 420.588800);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('c', ANY_C);
      return mod;
    }
    case 1986: {
      Modification mod("Diethylphosphothione", "O-diethylphosphothione", 152.006087, 152.151800);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 1990: {
      Modification mod("CIGG", "Ubiquitin D (FAT10) leaving after chymotrypsin digestion Cys-Ile-Gly-Gly", 330.136176, 330.403200);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1991: {
      Modification mod("GNLLFLACYCIGG", "Ubiquitin D (FAT10) leaving after trypsin digestion Gly-Asn-Leu-Leu-Phe-Leu-Ala-Cys-Tyr-Cys-Ile-Gly-Gly", 1324.630800, 1325.598000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1987: {
      Modification mod("Dimethylphosphothione", "O-dimethylphosphothione", 123.974787, 124.098700);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 1989: {
      Modification mod("monomethylphosphothione", "O-methylphosphothione", 109.959137, 110.072100);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 1993: {
      Modification mod("TMPP-Ac:13C(9)", "heavy tris(2,4,6-trimethoxyphenyl)phosphonium acetic acid N-hydroxysuccinimide ester derivative", 581.211328, 581.474000);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      return mod;
    }
    case 2036: {
      Modification mod("Lys+O(2)", "Photo-induced Lysine adduct", 160.084792, 160.171100);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 2001: {
      Modification mod("ZQG", "carbobenzoxy-L-glutaminyl-glycine", 320.100836, 320.297300);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 1999: {
      Modification mod("Xlink:DST[56]", "DST crosslinker cleaved by sodium periodate", 55.989829, 56.020200);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2006: {
      Modification mod("Haloxon", "O-Dichloroethylphosphate", 203.950987, 204.976300);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2008: {
      Modification mod("Methamidophos-O", "O-methyl amino phosphinate", 92.997965, 93.021700);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2014: {
      Modification mod("Nitrene", "Loss of O2; nitro photochemical decomposition", 12.995249, 12.998800);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 2015: {
      Modification mod("shTMT", "Super Heavy Tandem Mass Tag", 235.176741, 235.220100);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2016: {
      Modification mod("TMTpro", "TMTpro 16plex Tandem Mass Tag", 304.207146, 304.312700);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2017: {
      Modification mod("TMTpro_zero", "Native TMTpro Tandem Mass Tag", 295.189592, 295.377300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      return mod;
    }
    case 2041: {
      Modification mod("3-hydroxybenzyl-phosphate", "3-hydroxybenzyl phosphate", 186.008196, 186.101800);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 2028: {
      Modification mod("Hex(6)HexNAc(5)NeuAc(3)", "A3G3S3", 2861.000054, 2862.569900);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 2025: {
      Modification mod("Andro-H2O", "andrographolide with the loss of H2O", 332.198760, 332.433900);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2027: {
      Modification mod("His+O(2)", "Photo-induced histidine adduct", 169.048741, 169.138100);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 2029: {
      Modification mod("Hex(7)HexNAc(6)", "A4G4", 2352.846000, 2354.139300);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('N', ANYWHERE);
      return mod;
    }
    case 2033: {
      Modification mod("Met+O(2)", "Photo-induced Methionine Adduct", 163.030314, 163.194900);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 2034: {
      Modification mod("Gly+O(2)", "Photo-induced Glycine Adduct", 89.011293, 89.050100);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 2037: {
      Modification mod("Glu+O(2)", "Photo-induced Glutamate adduct", 161.032422, 161.112800);
      mod.addSpecificity('H', ANYWHERE);
      return mod;
    }
    case 2040: {
      Modification mod("MBS+peptide", "MBS_233p24 plus peptide 1250p53", 1482.770000, 1483.759700);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2042: {
      Modification mod("phenyl-phosphate", "phenyl phosphate", 155.997631, 156.075900);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 2044: {
      Modification mod("RBS-ID_Uridine", "RNA-protein UVC-crosslinked, hydrofluoride-digested uridine adduct", 244.069536, 244.201400);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 2054: {
      Modification mod("pRBS-ID_4-thiouridine", "RNA-protein UVA-crosslinked, hydrofluoride-digested 4-thiouridine adduct", 226.058972, 226.186100);
      mod.addSpecificity('F', ANYWHERE);
      return mod;
    }
    case 2053: {
      Modification mod("Biotin:Aha-PC", "Intact PC Biotin Alkyne tag", 690.243160, 690.724600);
      mod.addSpecificity('M', ANYWHERE);
      return mod;
    }
    case 2062: {
      Modification mod("DBIA", "desthiobiotinylation of cysteine with DBIA probe", 296.184841, 296.365400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2055: {
      Modification mod("pRBS-ID_6-thioguanosine", "RNA-protein UVA-crosslinked, hydrofluoride-digested 6-thioguanosine adduct", 265.081104, 265.225400);
      mod.addSpecificity('W', ANYWHERE);
      return mod;
    }
    case 2057: {
      Modification mod("6C-CysPAT", "Iodoacetamido-LC-Phosphonic Acid derivative", 221.081695, 221.190700);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('H', ANYWHERE);
      mod.addSpecificity('n', ANY_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2058: {
      Modification mod("Xlink:DSPP[210]", "Intact DSPP/TBDSPP crosslinker", 209.971810, 210.080200);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2059: {
      Modification mod("Xlink:DSPP[228]", "Water-quenched monolink of DSPP/TBDSPP crosslinker", 227.982375, 228.095500);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2060: {
      Modification mod("Xlink:DSPP[331]", "Tris-quenched monolink of DSPP/TBDSPP crosslinker", 331.045704, 331.215200);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2061: {
      Modification mod("Xlink:DSPP[226]", "Ammonia-quenched monolink of DSPP/TBDSPP crosslinker", 225.990534, 226.102800);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('n', PROTEIN_N);
      return mod;
    }
    case 2067: {
      Modification mod("Mono_Nγ-propargyl-L-Gln_desthiobiotin", "Monomodification of N-propargyl-L-Gln probe with clicked desthiobiotin-azide", 580.333296, 580.677000);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 2068: {
      Modification mod("Di_L-Glu_Nγ-propargyl-L-Gln_desthiobiotin", "Dimodification of L-Glu and N-propargyl-L-Gln probe with clicked desthiobiotin-azide", 709.375889, 709.790900);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 2069: {
      Modification mod("Di_L-Gln_Nγ-propargyl-L-Gln_desthiobiotin", "Dimodification of L-Gln and N-propargyl-L-Gln probe with clicked desthiobiotin-azide", 708.391873, 708.806200);
      mod.addSpecificity('E', ANYWHERE);
      mod.addSpecificity('D', ANYWHERE);
      return mod;
    }
    case 2070: {
      Modification mod("L-Gln", "Monomodification with glutamine", 128.058578, 128.129200);
      mod.addSpecificity('D', ANYWHERE);
      mod.addSpecificity('E', ANYWHERE);
      return mod;
    }
    case 2072: {
      Modification mod("Glyceroyl", "Glyceroylation", 88.016044, 88.062100);
      mod.addSpecificity('n', PROTEIN_N);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('Y', ANYWHERE);
      return mod;
    }
    case 2073: {
      Modification mod("N6pAMP", "Plain N6-Propargyl-AMP modified proteins without any clicked enrichment tag", 367.068170, 367.253900);
      mod.addSpecificity('Y', ANYWHERE);
      mod.addSpecificity('T', ANYWHERE);
      mod.addSpecificity('S', ANYWHERE);
      return mod;
    }
    case 2074: {
      Modification mod("DABCYL-C2-maleimide", "DABCYL-C2-maleimide Thiol-reactive dye for fluorescence labelling of proteins", 391.164440, 391.423100);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2081: {
      Modification mod("Ethynyl", "Ethynlation of cysteine residues", 24.000000, 24.021400);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
  case 2079: {
      Modification mod("NBF", "Thiol blocking reagent", 163.001791, 163.090400);
      mod.addSpecificity('R', ANYWHERE);
      mod.addSpecificity('K', ANYWHERE);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2080: {
      Modification mod("DCP", "Dimedone-Based Chemical Probes", 168.078644, 168.189800);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2082: {
      Modification mod("QQTGG", "SUMOylation leaving QQTGG", 471.207761, 471.465000);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2083: {
      Modification mod("Pyro-QQTGG", "SUMOylation leaving Pyro-QQTGG", 454.181212, 454.434400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2084: {
      Modification mod("NQTGG", "SUMOylation leaving NQTGG", 457.192111, 457.438400);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2085: {
      Modification mod("DVFQQQTGG", "SUMOylation by Endogenous SUMO2/3 following Lys C and Asp-N serial digestion", 960.430110, 960.986500);
      mod.addSpecificity('K', ANYWHERE);
      return mod;
    }
    case 2086: {
      Modification mod("iST-NHS specific cysteine modification", "Preomics iST-NHS Kit specific cysteine modification", 113.084064, 113.157600);
      mod.addSpecificity('C', ANYWHERE);
      return mod;
    }
    case 2088: {
      Modification mod("Label:13C(2)15N(1)", "13C(2) 15N(1) Silac label", 3.003745, 2.978700);
      mod.addSpecificity('G', ANYWHERE);
      return mod;
    }
  }
}

}

#endif

