/**
 * DIAmeterPSMFilter.h
 * DATE: June 17, 2021
 * AUTHOR: Yang Lu
 * DESCRIPTION: Object for filtering the PSMs generated by DIAmeter.
 **************************************************************************/

#ifndef DIAMETERPSMFILTER_H
#define DIAMETERPSMFILTER_H

#include "DelimitedFileReader.h"
#include "MatchColumns.h"
#include "PSMReader.h"
#include "boost/tuple/tuple.hpp"

// It is the struct to store the DIAmeter PSM features,
// which is easy to group by (scan, charge), sort by XCorr,
// and filter by the ensemble score
struct PSMByScanCharge {
  double xcorr_score_;
  double ensemble_score_;
  std::vector<std::string> data_;

  explicit PSMByScanCharge(double xcorr_score_tmp, double ensemble_score_tmp, std::vector<std::string> data_tmp) {
    xcorr_score_ = xcorr_score_tmp;
    ensemble_score_ = ensemble_score_tmp;
    data_ = data_tmp;
  }
};

class DIAmeterPSMFilter {
 protected:
    int match_indices_[NUMBER_MATCH_COLUMNS];
    std::vector<MATCH_COLUMNS_T> toagg_column_ids_;
    std::vector<int> toagg_column_indices_;
    std::vector<double> toagg_column_coeffs_;
    int agg_idx_, scan_idx_, charge_idx_, xcorr_idx_;
    DelimitedFileReader* fileReader_;

    // we use (scan*10+charge) as the key
    std::map<int, boost::tuple<double, double>> scan_charge_scores_map;

    void parseHeader();
    int getKey(int scan, int charge);

    static bool psm_sorter(const PSMByScanCharge & psm1, const PSMByScanCharge & psm2);

 public:
    DIAmeterPSMFilter(const char* file_name);
    ~DIAmeterPSMFilter();

    void calcBaseline();
    void loadAndFilter(const char* output_file_name, bool filter=true);
};

#endif //DIAMETERPSMFILTER_H

