/**
 * DIAmeterFeatureScaler.h
 * DATE: June 15, 2021
 * AUTHOR: Yang Lu
 * DESCRIPTION: Object for reading and scaling the tab-delimited files generated by DIAmeter.
 **************************************************************************/

#ifndef DIAMETERFEATURESCALER_H
#define DIAMETERFEATURESCALER_H

#include "DelimitedFileReader.h"
#include "MatchColumns.h"
#include "PSMReader.h"

class DIAmeterFeatureScaler {
  protected:
    void parseHeader();
    int match_indices_[NUMBER_MATCH_COLUMNS];

    std::vector<MATCH_COLUMNS_T> toscale_column_ids_;
    std::vector<int> toscale_column_indices_;
    std::vector<pair<double, double>> toscale_column_quantiles_;
    std::vector<double>* toscale_match_values_[NUMBER_MATCH_COLUMNS];

    DelimitedFileReader* fileReader_;

  public:
    DIAmeterFeatureScaler(const char* file_name);
    ~DIAmeterFeatureScaler();

    std::vector<bool> getMatchColumnsPresent();
    void calcDataQuantile(double quantile_low=0.01, double quantile_high=0.99);
    void writeScaledFile(const char* output_file_name);
};

#endif //DIAMETERFEATURESCALER_H

